/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitPullDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitPull
extends GitMergeAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.getString("pull.action.name");
    }

    @Override
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        final GitPullDialog dialog = new GitPullDialog(project, gitRoots, defaultRoot);
        if (!dialog.showAndGet()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(dialog.gitRoot());
        assert (repository != null) : "Repository can't be null for root " + dialog.gitRoot();
        String remoteOrUrl = dialog.getRemote();
        if (remoteOrUrl == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteOrUrl);
        final List<String> urls = remote == null ? Collections.singletonList(remoteOrUrl) : remote.getUrls();
        Computable<GitLineHandler> handlerProvider = new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return dialog.makeHandler(urls);
            }
        };
        return new GitMergeAction.DialogState(dialog.gitRoot(), GitBundle.message("pulling.title", dialog.getRemote()), handlerProvider);
    }
}

