/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private TObjectIntHashMap<VcsRevisionNumber> myRevisionMap;
    private final LineAnnotationAspect DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

        @Override
        public String doGetValue(LineInfo info) {
            return DateFormatUtil.formatPrettyDate((Date)info.getDate());
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return String.valueOf(lineInfo.getRevisionNumber().getShortRev());
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return lineInfo.getAuthor();
        }
    };

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        super(project);
        this.myProject = project;
        this.myFile = file;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        this.myBaseRevision = revision;
        this.myLines = lines;
    }

    public GitFileAnnotation(@NotNull GitFileAnnotation annotation) {
        this(annotation.getProject(), annotation.getFile(), annotation.getCurrentRevision(), annotation.getLines());
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFile, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        this.myRevisions = revisions;
        this.myRevisionMap = new TObjectIntHashMap();
        for (int i = 0; i < this.myRevisions.size(); ++i) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i).getRevisionNumber(), i);
        }
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        VcsFileRevision fileRevision = null;
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.contains((Object)revisionNumber)) {
            fileRevision = this.myRevisions.get(this.myRevisionMap.get((Object)revisionNumber));
        }
        String commitMessage = fileRevision != null ? fileRevision.getCommitMessage() : lineInfo.getSubject() + "\n...";
        return GitBundle.message("annotation.tool.tip", revisionNumber.asString(), lineInfo.getAuthor(), DateFormatUtil.formatDateTime((Date)lineInfo.getDate()), commitMessage);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getDate() : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        return this.myLines;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @Nullable
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        };
    }

    @Nullable
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new FileAnnotation.PreviousFileRevisionProvider(){

            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                int index;
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
                if (lineInfo == null) {
                    return null;
                }
                VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
                if (previousFileRevision != null) {
                    return previousFileRevision;
                }
                GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
                if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.contains((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.get((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                    return (VcsFileRevision)GitFileAnnotation.this.myRevisions.get(index + 1);
                }
                return null;
            }

            @Nullable
            public VcsFileRevision getLastRevision() {
                if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                    return new GitFileRevision(GitFileAnnotation.this.myProject, VcsUtil.getFilePath((VirtualFile)GitFileAnnotation.this.myFile), (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
                }
                return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
            }
        };
    }

    @Nullable
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        HashMap authorsMap = new HashMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null || authorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
            authorsMap.put(lineInfo.getRevisionNumber(), lineInfo.getAuthor());
        }
        return () -> GitFileAnnotation.lambda$getAuthorsMappingProvider$1((Map)authorsMap);
    }

    @Nullable
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null) continue;
            GitRevisionNumber number = lineInfo.getRevisionNumber();
            Date date = lineInfo.getDate();
            dates.putValue((Object)date, (Object)number);
        }
        ArrayList orderedRevisions = new ArrayList();
        NavigableSet orderedDates = dates.navigableKeySet();
        for (Date date : orderedDates.descendingSet()) {
            Collection revisionNumbers = dates.get((Object)date);
            orderedRevisions.add(new ArrayList(revisionNumbers));
        }
        return () -> orderedRevisions;
    }

    private static /* synthetic */ Map lambda$getAuthorsMappingProvider$1(Map authorsMap) {
        return authorsMap;
    }

    static class LineInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        private final String mySubject;

        public LineInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date date, @NotNull VcsUser author, @NotNull String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myDate = date;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            return this.myRevision;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getDate() {
            return this.myDate;
        }

        @NotNull
        public String getAuthor() {
            return this.myAuthor.getName();
        }

        @NotNull
        public String getSubject() {
            return this.mySubject;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (VirtualFile)GitFileAnnotation.this.myFile, (VcsKey)GitVcs.getKey());
            }
        }
    }
}

