/*
 * Decompiled with CFR 0.152.
 */
package git4idea.attributes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.attributes.GitAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCheckAttrParser {
    private static final Logger LOG = Logger.getInstance(GitCheckAttrParser.class);
    private static final String UNSPECIFIED_VALUE = "unspecified";
    @NotNull
    private final Map<String, Collection<GitAttribute>> myAttributes = new HashMap<String, Collection<GitAttribute>>();

    private GitCheckAttrParser(@NotNull List<String> output) {
        for (String line : output) {
            if (line.isEmpty()) continue;
            List split = StringUtil.split((String)line, (String)":");
            LOG.assertTrue(split.size() == 3, (Object)String.format("Output doesn't match the expected format. Line: %s%nAll output:%n%s", line, StringUtil.join(output, (String)"\n")));
            String file = ((String)split.get(0)).trim();
            String attribute = ((String)split.get(1)).trim();
            String info = ((String)split.get(2)).trim();
            GitAttribute attr = GitAttribute.forName(attribute);
            if (attr == null || info.equalsIgnoreCase(UNSPECIFIED_VALUE)) continue;
            this.myAttributes.computeIfAbsent(file, f -> new ArrayList()).add(attr);
        }
    }

    @NotNull
    public static GitCheckAttrParser parse(@NotNull List<String> output) {
        return new GitCheckAttrParser(output);
    }

    @NotNull
    public Map<String, Collection<GitAttribute>> getAttributes() {
        return this.myAttributes;
    }
}

