/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import git4idea.GitBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepComparator
implements VcsLogHighlighter,
Disposable {
    private static final Logger LOG = Logger.getInstance(DeepComparator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogUi myUi;
    @Nullable
    private MyTask myTask;
    @Nullable
    private Set<CommitId> myNonPickedCommits;

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager manager, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        this.myProject = project;
        this.myRepositoryManager = manager;
        this.myUi = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void highlightInBackground(@NotNull String branchToCompare, @NotNull VcsLogDataProvider dataProvider) {
        if (this.myTask != null) {
            LOG.error("Shouldn't be possible");
            return;
        }
        Map<GitRepository, GitBranch> repositories = this.getRepositories(this.myUi.getDataPack().getLogProviders(), branchToCompare);
        if (repositories.isEmpty()) {
            this.removeHighlighting();
            return;
        }
        this.myTask = new MyTask(this.myProject, repositories, dataProvider, branchToCompare);
        this.myTask.queue();
    }

    @NotNull
    private Map<GitRepository, GitBranch> getRepositories(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull String branchToCompare) {
        HashMap repos = ContainerUtil.newHashMap();
        for (VirtualFile root : providers.keySet()) {
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null || repository.getCurrentBranch() == null || repository.getBranches().findBranchByName(branchToCompare) == null) continue;
            repos.put(repository, repository.getCurrentBranch());
        }
        return repos;
    }

    public void stopAndUnhighlight() {
        this.stopTask();
        this.removeHighlighting();
    }

    private void stopTask() {
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
    }

    private void removeHighlighting() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myNonPickedCommits = null;
    }

    public void dispose() {
        this.stopAndUnhighlight();
    }

    public boolean hasHighlightingOrInProgress() {
        return this.myTask != null;
    }

    public static DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogUi logUi) {
        return ((DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class)).getInstance(logUi);
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
        if (this.myNonPickedCommits == null) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        return VcsCommitStyleFactory.foreground((Color)(!this.myNonPickedCommits.contains(new CommitId((Hash)commitDetails.getId(), commitDetails.getRoot())) ? MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND : null));
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (this.myTask == null) {
            return;
        }
        String comparedBranch = this.myTask.myComparedBranch;
        VcsLogBranchFilter branchFilter = dataPack.getFilters().getBranchFilter();
        if (branchFilter == null || !this.myTask.myComparedBranch.equals(VcsLogUtil.getSingleFilteredBranch((VcsLogBranchFilter)branchFilter, (VcsLogRefs)dataPack.getRefs()))) {
            this.stopAndUnhighlight();
            return;
        }
        if (refreshHappened) {
            Map repositoriesWithCurrentBranches = this.myTask.myRepositoriesWithCurrentBranches;
            VcsLogDataProvider provider = this.myTask.myProvider;
            this.stopTask();
            Map<GitRepository, GitBranch> repositories = this.getRepositories(dataPack.getLogProviders(), comparedBranch);
            if (repositories.equals(repositoriesWithCurrentBranches)) {
                this.highlightInBackground(comparedBranch, provider);
            } else {
                this.removeHighlighting();
            }
        }
    }

    private class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<GitRepository, GitBranch> myRepositoriesWithCurrentBranches;
        @NotNull
        private final VcsLogDataProvider myProvider;
        @NotNull
        private final String myComparedBranch;
        @NotNull
        private final Set<CommitId> myCollectedNonPickedCommits;
        @Nullable
        private VcsException myException;
        private boolean myCancelled;

        public MyTask(@NotNull Project project, @NotNull Map<GitRepository, GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataProvider dataProvider, String branchToCompare) {
            super(project, "Comparing Branches...");
            this.myCollectedNonPickedCommits = ContainerUtil.newHashSet();
            this.myProject = project;
            this.myRepositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.myProvider = dataProvider;
            this.myComparedBranch = branchToCompare;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                for (Map.Entry<GitRepository, GitBranch> entry : this.myRepositoriesWithCurrentBranches.entrySet()) {
                    GitRepository repo = entry.getKey();
                    GitBranch currentBranch = entry.getValue();
                    this.myCollectedNonPickedCommits.addAll(this.getNonPickedCommitsFromGit(this.myProject, repo.getRoot(), currentBranch.getName(), this.myComparedBranch));
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myCancelled) {
                return;
            }
            DeepComparator.this.removeHighlighting();
            if (this.myException != null) {
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't compare with branch " + this.myComparedBranch, this.myException.getMessage());
                return;
            }
            DeepComparator.this.myNonPickedCommits = this.myCollectedNonPickedCommits;
        }

        public void cancel() {
            this.myCancelled = true;
        }

        @NotNull
        private Set<CommitId> getNonPickedCommitsFromGit(@NotNull Project project, final @NotNull VirtualFile root, @NotNull String currentBranch, @NotNull String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            final HashSet pickedCommits = ContainerUtil.newHashSet();
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.startsWith("+")) {
                        try {
                            line = line.substring(2).trim();
                            int firstSpace = line.indexOf(32);
                            if (firstSpace > 0) {
                                line = line.substring(0, firstSpace);
                            }
                            Hash hash = HashImpl.build((String)line);
                            pickedCommits.add(new CommitId(hash, root));
                        }
                        catch (Exception e) {
                            LOG.error("Couldn't parse line [" + line + "]");
                        }
                    }
                }
            });
            handler.runInCurrentThread(null);
            return pickedCommits;
        }
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "CHERRY_PICKED_COMMITS";

        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logDataManager, @NotNull VcsLogUi logUi) {
            return DeepComparator.getInstance(logDataManager.getProject(), logUi);
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getTitle() {
            return "Cherry Picked Commits";
        }

        public boolean showMenuItem() {
            return false;
        }
    }
}

