/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DeepComparatorHolder
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<VcsLogUi, DeepComparator> myComparators;

    private DeepComparatorHolder(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myComparators = ContainerUtil.newHashMap();
    }

    @NotNull
    public DeepComparator getInstance(final @NotNull VcsLogUi ui) {
        DeepComparator comparator = this.myComparators.get(ui);
        if (comparator == null) {
            comparator = new DeepComparator(this.myProject, this.myRepositoryManager, ui, this);
            this.myComparators.put(ui, comparator);
            if (ui instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)ui), (Disposable)new Disposable(){

                    public void dispose() {
                        DeepComparator removed = (DeepComparator)DeepComparatorHolder.this.myComparators.remove(ui);
                        if (removed != null) {
                            Disposer.dispose((Disposable)removed);
                        }
                    }
                });
            }
        }
        return comparator;
    }

    public void dispose() {
        this.myComparators.clear();
    }
}

