/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitCreateBranchOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.branch.GitRebaseParams;
import git4idea.branch.GitRenameBranchOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.history.GitHistoryUtils;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDialog;
import git4idea.util.GitCommitCompareInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitBranchUiHandler myUiHandler;

    public GitBranchWorker(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler) {
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
    }

    public void checkoutNewBranch(final @NotNull String name, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        repositories = ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                return currentBranch == null || !currentBranch.getName().equals(name);
            }
        });
        if (!repositories.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        GitBranchWorker.updateInfo(startPoints.keySet());
        new GitCreateBranchOperation(this.myProject, this.myGit, this.myUiHandler, name, startPoints).execute();
    }

    public void createNewTag(@NotNull String name, @NotNull String reference, @NotNull List<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            this.myGit.createNewTag(repository, name, null, reference);
            repository.getRepositoryFiles().refresh(false);
        }
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, startPoint, false, true, newBranchName).execute();
    }

    public void checkout(@NotNull String reference, boolean detach, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, reference, detach, false, null).execute();
    }

    public void deleteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void merge(@NotNull String branchName, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitMergeOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName, deleteOnMerge).execute();
    }

    public void rebase(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(branchName), this.myUiHandler.getProgressIndicator());
    }

    public void rebaseOnCurrent(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(branchName, null, "HEAD", false, false), this.myUiHandler.getProgressIndicator());
    }

    public void renameBranch(@NotNull String currentName, @NotNull String newName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitRenameBranchOperation(this.myProject, this.myGit, this.myUiHandler, currentName, newName, repositories).execute();
    }

    public void compare(final @NotNull String branchName, final @NotNull List<GitRepository> repositories, final @NotNull GitRepository selectedRepository) {
        final GitCommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
        if (myCompareInfo == null) {
            LOG.error("The task to get compare info didn't finish. Repositories: \n" + repositories + "\nbranch name: " + branchName);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GitBranchWorker.this.displayCompareDialog(branchName, GitBranchUtil.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository);
            }
        });
    }

    private GitCommitCompareInfo loadCommitsToCompare(List<GitRepository> repositories, String branchName) {
        GitCommitCompareInfo compareInfo = new GitCommitCompareInfo();
        for (GitRepository repository : repositories) {
            compareInfo.put(repository, (Pair<List<GitCommit>, List<GitCommit>>)this.loadCommitsToCompare(repository, branchName));
            compareInfo.put(repository, GitBranchWorker.loadTotalDiff(repository, branchName));
        }
        return compareInfo;
    }

    @NotNull
    private static Collection<Change> loadTotalDiff(@NotNull GitRepository repository, @NotNull String branchName) {
        try {
            return GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), branchName, null, true);
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git diff " + branchName + "] on repository [" + repository.getRoot() + "]", e);
        }
    }

    @NotNull
    private Couple<List<GitCommit>> loadCommitsToCompare(@NotNull GitRepository repository, @NotNull String branchName) {
        List<GitCommit> branchToHead;
        List<GitCommit> headToBranch;
        try {
            headToBranch = GitHistoryUtils.history(this.myProject, repository.getRoot(), ".." + branchName);
            branchToHead = GitHistoryUtils.history(this.myProject, repository.getRoot(), branchName + "..");
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git log .." + branchName + "] on repository [" + repository.getRoot() + "]", e);
        }
        return Couple.of(headToBranch, branchToHead);
    }

    private void displayCompareDialog(@NotNull String branchName, @NotNull String currentBranch, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository selectedRepository) {
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)String.format("<html>There are no changes between <code>%s</code> and <code>%s</code></html>", currentBranch, branchName), (String)"No Changes Detected");
        } else {
            new GitCompareBranchesDialog(this.myProject, branchName, currentBranch, compareInfo, selectedRepository).show();
        }
    }

    private static void updateInfo(@NotNull Collection<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }
}

