/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;

    GitBrancherImpl(@NotNull Project project, @NotNull Git git) {
        this.myProject = project;
        this.myGit = git;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }
        }.runInBackground();
    }

    private GitBranchWorker newWorker(ProgressIndicator indicator) {
        return new GitBranchWorker(this.myProject, this.myGit, new GitBranchUiHandlerImpl(this.myProject, this.myGit, indicator));
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints) {
        new CommonBackgroundTask(this.myProject, "Creating branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints);
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, "Checking out " + reference, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, String.format("Checking out %s from %s", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void compare(final @NotNull String branchName, final @NotNull List<GitRepository> repositories, final @NotNull GitRepository selectedRepository) {
        new CommonBackgroundTask(this.myProject, "Comparing with " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).compare(branchName, repositories, selectedRepository);
            }
        }.runInBackground();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Merging " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<GitRepository> repositories, final @NotNull String branchName) {
        new CommonBackgroundTask(this.myProject, "Rebasing onto " + branchName, null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(final @NotNull List<GitRepository> repositories, final @NotNull String branchName) {
        new CommonBackgroundTask(this.myProject, "Rebasing " + branchName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).rebaseOnCurrent(repositories, branchName);
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Renaming " + currentName + " to " + newName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories);
            }
        }.runInBackground();
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    this.myCallInAwtAfterExecution.run();
                } else {
                    application.invokeLater(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
                }
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }
    }
}

