/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteRemoteBranchOperation
extends GitBranchOperation {
    private final String myBranchName;

    public GitDeleteRemoteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull List<GitRepository> repositories, @NotNull String name) {
        super(project, git, handler, repositories);
        this.myBranchName = name;
    }

    @Override
    protected void execute() {
        boolean deletedSuccessfully;
        Collection<GitRepository> repositories = this.getRepositories();
        Collection<String> commonTrackingBranches = GitDeleteRemoteBranchOperation.getCommonTrackingBranches(this.myBranchName, repositories);
        for (GitRepository repository : repositories) {
            String currentBranch = repository.getCurrentBranchName();
            if (currentBranch == null) continue;
            commonTrackingBranches.remove(currentBranch);
        }
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)this.myUiHandler.confirmRemoteBranchDeletion(this.myBranchName, commonTrackingBranches, repositories)));
        if (decision.get() != GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL && (deletedSuccessfully = this.doDeleteRemote(this.myBranchName, repositories))) {
            final ArrayList<String> successfullyDeletedLocalBranches = new ArrayList<String>(1);
            if (decision.get() == GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING) {
                for (final String branch : commonTrackingBranches) {
                    this.getIndicator().setText("Deleting " + branch);
                    new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branch){

                        @Override
                        protected void notifySuccess(@NotNull String message) {
                            successfullyDeletedLocalBranches.add(branch);
                        }
                    }.execute();
                }
            }
            this.notifySuccessfulDeletion(this.myBranchName, successfullyDeletedLocalBranches);
        }
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Collection<String> getCommonTrackingBranches(@NotNull String remoteBranch, @NotNull Collection<GitRepository> repositories) {
        return new GitMultiRootBranchConfig(repositories).getCommonTrackingBranches(remoteBranch);
    }

    private boolean doDeleteRemote(@NotNull String branchName, @NotNull Collection<GitRepository> repositories) {
        Couple<String> pair = GitDeleteRemoteBranchOperation.splitNameOfRemoteBranch(branchName);
        String remoteName = (String)pair.getFirst();
        String branch = (String)pair.getSecond();
        GitCompoundResult result = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            GitCommandResult res;
            GitRemote remote = GitDeleteRemoteBranchOperation.getRemoteByName(repository, remoteName);
            if (remote == null) {
                String error = "Couldn't find remote by name: " + remoteName;
                LOG.error(error);
                res = GitCommandResult.error(error);
            } else {
                res = this.pushDeletion(repository, remote, branch);
                if (!res.success() && GitDeleteRemoteBranchOperation.isAlreadyDeletedError(res.getErrorOutputAsJoinedString())) {
                    res = this.myGit.remotePrune(repository, remote);
                }
            }
            result.append(repository, res);
            repository.update();
        }
        if (!result.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Failed to delete remote branch " + branchName, result.getErrorOutputWithReposIndication());
        }
        return result.totalSuccess();
    }

    private static boolean isAlreadyDeletedError(@NotNull String errorOutput) {
        return errorOutput.contains("remote ref does not exist");
    }

    private static Couple<String> splitNameOfRemoteBranch(String branchName) {
        int firstSlash = branchName.indexOf(47);
        String remoteName = firstSlash > -1 ? branchName.substring(0, firstSlash) : branchName;
        String remoteBranchName = branchName.substring(firstSlash + 1);
        return Couple.of((Object)remoteName, (Object)remoteBranchName);
    }

    @NotNull
    private GitCommandResult pushDeletion(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        return this.myGit.push(repository, remote, ":" + branchName, false, false, null, new GitLineHandlerListener[0]);
    }

    @Nullable
    private static GitRemote getRemoteByName(@NotNull GitRepository repository, @NotNull String remoteName) {
        for (GitRemote remote : repository.getRemotes()) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    private void notifySuccessfulDeletion(@NotNull String remoteBranchName, @NotNull Collection<String> localBranches) {
        String message = "";
        if (!localBranches.isEmpty()) {
            message = "Also deleted local " + StringUtil.pluralize((String)"branch", (int)localBranches.size()) + ": " + StringUtil.join(localBranches, (String)", ");
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Deleted remote branch " + remoteBranchName, message);
    }
}

