/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRenameBranchOperation
extends GitBranchOperation {
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final String myCurrentName;
    @NotNull
    private final String myNewName;

    public GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String currentName, @NotNull String newName, @NotNull List<GitRepository> repositories) {
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result = this.myGit.renameBranch(repository, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (result.success()) {
                GitRenameBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError("Couldn't rename " + this.myCurrentName + " to " + this.myNewName, result.getErrorOutputAsJoinedString());
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            result.append(repository, this.myGit.renameBranch(repository, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]));
            GitRenameBranchOperation.refresh(repository);
        }
        if (result.totalSuccess()) {
            this.myNotifier.notifySuccess("Rollback Successful", "Renamed back to " + this.myCurrentName);
        } else {
            this.myNotifier.notifyError("Rollback Failed", result.getErrorOutputWithReposIndication());
        }
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return String.format("Branch <b><code>%s</code></b> was renamed to <b><code>%s</code></b>", this.myCurrentName, this.myNewName);
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return "However rename has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (rename branch back to " + this.myCurrentName + ") not to let branches diverge.";
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "rename";
    }

    private static void refresh(@NotNull GitRepository repository) {
        repository.update();
    }
}

