/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UnresolvedMergeCheckFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        return new CheckinHandler(){

            public CheckinHandler.ReturnResult beforeCheckin() {
                if (UnresolvedMergeCheckFactory.containsUnresolvedConflicts(panel)) {
                    int answer = Messages.showYesNoDialog((Component)panel.getComponent(), (String)"Are you sure you want to commit changes with unresolved conflicts?", (String)"Unresolved Conflicts", (Icon)Messages.getWarningIcon());
                    return answer == 0 ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
        };
    }

    private static boolean containsUnresolvedConflicts(@NotNull CheckinProjectPanel panel) {
        for (Change change : panel.getSelectedChanges()) {
            FileStatus status = change.getFileStatus();
            if (!status.equals(FileStatus.MERGE) && !status.equals(FileStatus.MERGED_WITH_BOTH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_PROPERTY_CONFLICTS)) continue;
            return true;
        }
        return false;
    }
}

