/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.CloneDvcsDialog;
import com.intellij.openapi.project.Project;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.remote.GitRememberedInputs;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCloneDialog
extends CloneDvcsDialog {
    @NotNull
    private final Git myGit = Git.getInstance();

    public GitCloneDialog(@NotNull Project project) {
        this(project, null);
    }

    public GitCloneDialog(@NotNull Project project, @Nullable String defaultUrl) {
        super(project, "Git", ".git", defaultUrl);
    }

    @NotNull
    protected CloneDvcsDialog.TestResult test(@NotNull String url) {
        GitCommandResult result = this.myGit.lsRemote(this.myProject, new File("."), url);
        return result.success() ? CloneDvcsDialog.TestResult.SUCCESS : new CloneDvcsDialog.TestResult(result.getErrorOutputAsJoinedString());
    }

    @NotNull
    protected DvcsRememberedInputs getRememberedInputs() {
        return GitRememberedInputs.getInstance();
    }

    protected String getDimensionServiceKey() {
        return "GitCloneDialog";
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }
}

