/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean mySuccess;
    private final int myExitCode;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    @Nullable
    private final Throwable myException;

    public GitCommandResult(boolean success, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable Throwable exception) {
        this.myExitCode = exitCode;
        this.mySuccess = success;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myException = exception;
    }

    @NotNull
    public static GitCommandResult merge(@Nullable GitCommandResult first, @NotNull GitCommandResult second) {
        if (first == null) {
            return second;
        }
        int mergedExitCode = first.myExitCode == 0 ? second.myExitCode : (second.myExitCode == 0 ? first.myExitCode : second.myExitCode);
        return new GitCommandResult(first.success() && second.success(), mergedExitCode, ContainerUtil.concat(first.myErrorOutput, second.myErrorOutput), ContainerUtil.concat(first.myOutput, second.myOutput), (Throwable)ObjectUtils.chooseNotNull((Object)second.myException, (Object)first.myException));
    }

    public boolean success() {
        return this.mySuccess;
    }

    @NotNull
    public List<String> getOutput() {
        return Collections.unmodifiableList(this.myOutput);
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @NotNull
    public List<String> getErrorOutput() {
        return Collections.unmodifiableList(this.myErrorOutput);
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"<br/>");
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
    }

    @NotNull
    private List<String> getErrorOrStdOutput() {
        return this.myErrorOutput.isEmpty() && !this.success() ? this.myOutput : this.myErrorOutput;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        return StringUtil.join(this.myOutput, (String)"\n");
    }

    @Nullable
    public Throwable getException() {
        return this.myException;
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        return new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList(), null);
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        return ContainerUtil.map(errorOutput, (Function)new Function<String, String>(){

            public String fun(String errorMessage) {
                return GitUtil.cleanupErrorPrefixes(errorMessage);
            }
        });
    }
}

