/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import git4idea.config.SSHConnectionSettings;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitSSHGUIHandler {
    @Nullable
    private final Project myProject;

    GitSSHGUIHandler(@Nullable Project project) {
        this.myProject = project;
    }

    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, String fingerprint, boolean isNew) {
        final String message = isNew ? GitBundle.message("ssh.new.host.key", hostname, port, fingerprint, serverHostKeyAlgorithm) : GitBundle.message("ssh.changed.host.key", hostname, port, fingerprint, serverHostKeyAlgorithm);
        final AtomicBoolean rc = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                rc.set(0 == Messages.showYesNoDialog((Project)GitSSHGUIHandler.this.myProject, (String)message, (String)GitBundle.getString("ssh.confirm.key.titile"), null));
            }
        }, ModalityState.any());
        return rc.get();
    }

    @Nullable
    public String askPassphrase(String username, String keyPath, boolean resetPassword, String lastError) {
        String error = this.processLastError(resetPassword, lastError);
        return CredentialPromptDialog.askPassword((Project)this.myProject, (String)GitBundle.getString("ssh.ask.passphrase.title"), (String)("Password for the SSH key \"" + PathUtil.getFileName((String)keyPath) + "\":"), (CredentialAttributes)CredentialAttributesKt.CredentialAttributes(GitSSHGUIHandler.class, (String)("PASSPHRASE:" + keyPath)), (boolean)resetPassword, (String)error);
    }

    @Nullable
    private String processLastError(boolean resetPassword, final String lastError) {
        String error;
        if (lastError != null && lastError.length() != 0 && !resetPassword) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GitSSHGUIHandler.this.showError(lastError);
                }
            }, ModalityState.any());
            error = null;
        } else {
            error = lastError != null && lastError.length() == 0 ? null : lastError;
        }
        return error;
    }

    private void showError(String lastError) {
        if (lastError.length() != 0) {
            Messages.showErrorDialog((Project)this.myProject, (String)lastError, (String)GitBundle.getString("ssh.error.title"));
        }
    }

    public Vector<String> replyToChallenge(final String username, final String name, final String instruction, final int numPrompts, final Vector<String> prompt, final Vector<Boolean> echo, final String lastError) {
        final AtomicReference rc = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GitSSHGUIHandler.this.showError(lastError);
                GitSSHKeyboardInteractiveDialog dialog = new GitSSHKeyboardInteractiveDialog(name, numPrompts, instruction, prompt, echo, username);
                if (dialog.showAndGet()) {
                    rc.set(dialog.getResults());
                }
            }
        }, ModalityState.any());
        return (Vector)rc.get();
    }

    @Nullable
    public String askPassword(String username, boolean resetPassword, String lastError) {
        String error = this.processLastError(resetPassword, lastError);
        return CredentialPromptDialog.askPassword((Project)this.myProject, (String)GitBundle.getString("ssh.password.title"), (String)GitBundle.message("ssh.password.message", username), (CredentialAttributes)CredentialAttributesKt.CredentialAttributes(GitSSHGUIHandler.class, (String)("PASSWORD:" + username)), (boolean)resetPassword, (String)error);
    }

    public String getLastSuccessful(String userName) {
        SSHConnectionSettings s = SSHConnectionSettings.getInstance();
        String rc = s.getLastSuccessful(userName);
        return rc == null ? "" : rc;
    }

    public void setLastSuccessful(String userName, String method, final String error) {
        SSHConnectionSettings s = SSHConnectionSettings.getInstance();
        s.setLastSuccessful(userName, method);
        if (error != null && error.length() != 0) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GitSSHGUIHandler.this.showError(error);
                }
            });
        }
    }

    private class GitSSHKeyboardInteractiveDialog
    extends DialogWrapper {
        JTextComponent[] inputs;
        JPanel contents;
        private final int myNumPrompts;
        private final String myInstruction;
        private final Vector<String> myPrompt;
        private final Vector<Boolean> myEcho;
        private final String myUserName;

        public GitSSHKeyboardInteractiveDialog(String name, int numPrompts, String instruction, Vector<String> prompt, Vector<Boolean> echo, String userName) {
            super(GitSSHGUIHandler.this.myProject, true);
            this.myNumPrompts = numPrompts;
            this.myInstruction = instruction;
            this.myPrompt = prompt;
            this.myEcho = echo;
            this.myUserName = userName;
            this.setTitle(GitBundle.message("ssh.keyboard.interactive.title", name));
            this.init();
            this.setResizable(true);
            this.setModal(true);
        }

        protected JComponent createCenterPanel() {
            if (this.contents == null) {
                GridBagConstraints c;
                int line = 0;
                this.contents = new JPanel(new GridBagLayout());
                this.inputs = new JTextComponent[this.myNumPrompts];
                JBInsets insets = JBUI.insets((int)1);
                if (this.myInstruction.length() != 0) {
                    JLabel instructionLabel = new JLabel(this.myInstruction);
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.gridx = 0;
                    c.gridy = line++;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 17;
                    this.contents.add((Component)instructionLabel, c);
                }
                c = new GridBagConstraints();
                c.insets = insets;
                c.anchor = 17;
                c.gridx = 0;
                c.gridy = line;
                this.contents.add((Component)new JLabel(GitBundle.getString("ssh.keyboard.interactive.username")), c);
                c = new GridBagConstraints();
                c.insets = insets;
                c.gridx = 1;
                c.gridy = line++;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.fill = 2;
                c.anchor = 17;
                this.contents.add((Component)new JLabel(this.myUserName), c);
                for (int i = 0; i < this.myNumPrompts; ++i) {
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.anchor = 17;
                    c.gridx = 0;
                    c.gridy = line;
                    JLabel promptLabel = new JLabel(this.myPrompt.get(i));
                    this.contents.add((Component)promptLabel, c);
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.gridx = 1;
                    c.gridy = line;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 17;
                    this.inputs[i] = this.myEcho.get(i) != false ? new JTextField(32) : new JPasswordField(32);
                    this.contents.add((Component)this.inputs[i], c);
                    ++line;
                }
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = line;
                c.gridwidth = 1;
                c.weighty = 1.0;
                c.fill = 3;
                c.anchor = 10;
                this.contents.add((Component)new JPanel(), c);
            }
            return this.contents;
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        public Vector<String> getResults() {
            Vector<String> rc = new Vector<String>(this.myNumPrompts);
            for (int i = 0; i < this.myNumPrompts; ++i) {
                rc.add(this.inputs[i].getText());
            }
            return rc;
        }

        public JComponent getPreferredFocusedComponent() {
            if (this.inputs.length > 0) {
                return this.inputs[0];
            }
            return super.getPreferredFocusedComponent();
        }
    }
}

