/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchType;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, GitVcsSettings.class);
    }

    @NotNull
    public UpdateMethod getUpdateType() {
        return (UpdateMethod)((Object)ObjectUtils.notNull((Object)((Object)this.myState.UPDATE_TYPE), (Object)((Object)UpdateMethod.BRANCH_DEFAULT)));
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        return this.myState.UPDATE_CHANGES_POLICY;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.PUSH_UPDATE_ALL_ROOTS;
    }

    public void setUpdateAllRootsIfPushRejected(boolean updateAllRoots) {
        this.myState.PUSH_UPDATE_ALL_ROOTS = updateAllRoots;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        return this.myState.ROOT_SYNC;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        this.myState.ROOT_SYNC = syncSetting;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(@NotNull String recentGitRootPath) {
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        return this.myState.RECENT_BRANCH_BY_REPOSITORY;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(@NotNull String branch) {
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        this.myState.RESET_MODE = mode;
    }

    public boolean isForcePushAllowed() {
        return this.myState.FORCE_PUSH_ALLOWED;
    }

    public void setForcePushAllowed(boolean allowed) {
        this.myState.FORCE_PUSH_ALLOWED = allowed;
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(@Nullable GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    public boolean shouldSignOffCommit() {
        return this.myState.SIGN_OFF_COMMIT;
    }

    public void setSignOffCommit(boolean state) {
        this.myState.SIGN_OFF_COMMIT = state;
    }

    @Deprecated
    public boolean isIdeaSsh() {
        if (this.getAppSettings().getIdeaSsh() == null) {
            this.getAppSettings().setIdeaSsh(this.myState.SSH_EXECUTABLE);
        }
        return this.getAppSettings().getIdeaSsh() == GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
    }

    @Nullable
    public GitRemoteBranch getPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch) {
        PushTargetInfo targetInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch);
        if (targetInfo == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, targetInfo.targetRemoteName);
        if (remote == null) {
            return null;
        }
        return GitUtil.findOrCreateRemoteBranch(repository, remote, targetInfo.targetBranchName);
    }

    public void setPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch, @NotNull String targetRemote, @NotNull String targetBranch) {
        String repositoryPath = repository.getRoot().getPath();
        PushTargetInfo existingInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch);
        if (existingInfo != null) {
            this.myState.PUSH_TARGETS.remove((Object)existingInfo);
        }
        this.myState.PUSH_TARGETS.add(new PushTargetInfo(repositoryPath, sourceBranch, targetRemote, targetBranch));
    }

    public void addToFavorites(@NotNull GitBranchType type, @Nullable GitRepository repository, @NotNull String branchName) {
        this.myState.FAVORITE_BRANCHES.add(type.toString(), (Repository)repository, branchName);
    }

    public void removeFromFavorites(@NotNull GitBranchType type, @Nullable GitRepository repository, @NotNull String branchName) {
        this.myState.FAVORITE_BRANCHES.remove(type.toString(), (Repository)repository, branchName);
    }

    public boolean isFavorite(@NotNull GitBranchType type, @Nullable Repository repository, @NotNull String branchName) {
        return this.myState.FAVORITE_BRANCHES.contains(type.toString(), repository, branchName);
    }

    public void excludedFromFavorites(@NotNull GitBranchType type, @Nullable GitRepository repository, @NotNull String branchName) {
        this.myState.EXCLUDED_FAVORITES.add(type.toString(), (Repository)repository, branchName);
    }

    public void removeFromExcluded(@NotNull GitBranchType type, @Nullable GitRepository repository, @NotNull String branchName) {
        this.myState.EXCLUDED_FAVORITES.remove(type.toString(), (Repository)repository, branchName);
    }

    public boolean isExcludedFromFavorites(@NotNull GitBranchType type, @Nullable Repository repository, @NotNull String branchName) {
        return this.myState.EXCLUDED_FAVORITES.contains(type.toString(), repository, branchName);
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        public PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }
    }

    public static class State {
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public GitVcsApplicationSettings.SshExecutable SSH_EXECUTABLE = GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public boolean PUSH_UPDATE_ALL_ROOTS = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public boolean FORCE_PUSH_ALLOWED = true;
        public GitPushTagMode PUSH_TAGS = null;
        public boolean SIGN_OFF_COMMIT = false;
        @AbstractCollection(surroundWithTag=false)
        @Tag(value="push-targets")
        public List<PushTargetInfo> PUSH_TARGETS = ContainerUtil.newArrayList();
        @Tag(value="favorite-branches")
        public BranchStorage FAVORITE_BRANCHES = new BranchStorage();
        @Tag(value="excluded-from-favorite")
        public BranchStorage EXCLUDED_FAVORITES = new BranchStorage();
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

