/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.GitHandler;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecord {
    private static final Logger LOG = Logger.getInstance(GitLogRecord.class);
    @NotNull
    private final Map<GitLogParser.GitLogOption, String> myOptions;
    @NotNull
    private final List<String> myPaths;
    @NotNull
    private final List<GitLogStatusInfo> myStatusInfo;
    private final boolean mySupportsRawBody;
    private GitHandler myHandler;

    GitLogRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, @NotNull List<String> paths, @NotNull List<GitLogStatusInfo> statusInfo, boolean supportsRawBody) {
        this.myOptions = options;
        this.myPaths = paths;
        this.myStatusInfo = statusInfo;
        this.mySupportsRawBody = supportsRawBody;
    }

    @NotNull
    private List<String> getPaths() {
        return this.myPaths;
    }

    @NotNull
    List<GitLogStatusInfo> getStatusInfos() {
        return this.myStatusInfo;
    }

    @NotNull
    public List<FilePath> getFilePaths(@NotNull VirtualFile root) throws VcsException {
        ArrayList<FilePath> res = new ArrayList<FilePath>();
        String prefix = root.getPath() + "/";
        for (String strPath : this.getPaths()) {
            String subPath = GitUtil.unescapePath(strPath);
            FilePath revisionPath = VcsUtil.getFilePathForDeletedFile((String)(prefix + subPath), (boolean)false);
            res.add(revisionPath);
        }
        return res;
    }

    @NotNull
    private String lookup(@NotNull GitLogParser.GitLogOption key) {
        String value = this.myOptions.get((Object)key);
        if (value == null) {
            LOG.error("Missing value for option " + (Object)((Object)key));
            return "";
        }
        return GitLogRecord.shortBuffer(value);
    }

    @NotNull
    String getHash() {
        return this.lookup(GitLogParser.GitLogOption.HASH);
    }

    @NotNull
    String getAuthorName() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_NAME);
    }

    @NotNull
    String getAuthorEmail() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_EMAIL);
    }

    @NotNull
    String getCommitterName() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_NAME);
    }

    @NotNull
    String getCommitterEmail() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_EMAIL);
    }

    @NotNull
    String getSubject() {
        return this.lookup(GitLogParser.GitLogOption.SUBJECT);
    }

    @NotNull
    String getBody() {
        return this.lookup(GitLogParser.GitLogOption.BODY);
    }

    @NotNull
    String getRawBody() {
        return this.lookup(GitLogParser.GitLogOption.RAW_BODY);
    }

    @NotNull
    String getShortenedRefLog() {
        return this.lookup(GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR);
    }

    @NotNull
    Date getDate() {
        return new Date(this.getCommitTime());
    }

    long getCommitTime() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.COMMIT_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get commit time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    long getAuthorTimeStamp() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.AUTHOR_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get author time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    String getFullMessage() {
        return this.mySupportsRawBody ? this.getRawBody().trim() : (this.getSubject() + "\n\n" + this.getBody()).trim();
    }

    @NotNull
    String[] getParentsHashes() {
        String parents = this.lookup(GitLogParser.GitLogOption.PARENTS);
        if (parents.trim().length() == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return parents.split(" ");
    }

    @NotNull
    public Collection<String> getRefs() {
        String decorate = this.myOptions.get((Object)GitLogParser.GitLogOption.REF_NAMES);
        return GitLogRecord.parseRefNames(decorate);
    }

    @NotNull
    private static List<String> parseRefNames(@Nullable String decoration) {
        if (decoration == null) {
            return ContainerUtil.emptyList();
        }
        int startParentheses = decoration.indexOf("(");
        int endParentheses = decoration.indexOf(")");
        if (startParentheses == -1 || endParentheses == -1) {
            return Collections.emptyList();
        }
        String refs = decoration.substring(startParentheses + 1, endParentheses);
        String[] names = refs.split(", ");
        ArrayList result = ContainerUtil.newArrayList();
        for (String item : names) {
            String POINTER = " -> ";
            if (item.contains(" -> ")) {
                List parts = StringUtil.split((String)item, (String)" -> ");
                result.addAll(ContainerUtil.map((Collection)parts, (Function)new Function<String, String>(){

                    public String fun(String s) {
                        return GitLogRecord.shortBuffer(s.trim());
                    }
                }));
                continue;
            }
            int colon = item.indexOf(58);
            result.add(GitLogRecord.shortBuffer(colon > 0 ? item.substring(colon + 1).trim() : item));
        }
        return result;
    }

    @NotNull
    private static String shortBuffer(@NotNull String raw) {
        return new String(raw);
    }

    @NotNull
    public List<Change> parseChanges(@NotNull Project project, @NotNull VirtualFile vcsRoot) throws VcsException {
        return GitChangesParser.parse(project, vcsRoot, this.myStatusInfo, this.getHash(), this.getDate(), Arrays.asList(this.getParentsHashes()));
    }

    public void setUsedHandler(GitHandler handler) {
        this.myHandler = handler;
    }

    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, myPaths=%s, myStatusInfo=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.myPaths, this.myStatusInfo, this.mySupportsRawBody, this.myHandler);
    }
}

