/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowExternalLogAction
extends DumbAwareAction {
    private static final String EXTERNAL = "EXTERNAL";

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && GitVcs.getInstance(e.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        List<VirtualFile> roots = GitShowExternalLogAction.getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs));
            return;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        Runnable showContent = () -> {
            ContentManager cm = window.getContentManager();
            if (GitShowExternalLogAction.checkIfProjectLogMatches(project, vcs, cm, roots) || GitShowExternalLogAction.checkIfAlreadyOpened(cm, roots)) {
                return;
            }
            String tabName = GitShowExternalLogAction.calcTabName(cm, roots);
            MyContentComponent component = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, tabName);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, tabName, false);
            content.setDisposer(component.myDisposable);
            content.setDescription("Log for " + StringUtil.join((Collection)roots, VirtualFile::getPath, (String)"\n"));
            content.setCloseable(true);
            cm.addContent(content);
            cm.setSelectedContent(content);
        };
        if (!window.isVisible()) {
            window.activate(showContent, true);
        } else {
            showContent.run();
        }
    }

    @NotNull
    private static MyContentComponent createManagerAndContent(@NotNull Project project, @NotNull GitVcs vcs, @NotNull List<VirtualFile> roots, @Nullable String tabName) {
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        for (VirtualFile root2 : roots) {
            repositoryManager.addExternalRepository(root2, GitRepositoryImpl.getInstance(root2, project, true));
        }
        VcsLogManager manager = new VcsLogManager(project, (VcsLogTabsProperties)ServiceManager.getService((Project)project, VcsLogTabsProperties.class), (Collection)ContainerUtil.map(roots, root -> new VcsRoot((AbstractVcs)vcs, root)));
        return new MyContentComponent(manager.createLogPanel(GitShowExternalLogAction.calcLogId(roots), tabName), roots, () -> {
            for (VirtualFile root : roots) {
                repositoryManager.removeExternalRepository(root);
            }
        });
    }

    @NotNull
    private static String calcLogId(@NotNull List<VirtualFile> roots) {
        return "EXTERNAL " + StringUtil.join(roots, VirtualFile::getPath, (String)File.pathSeparator);
    }

    @NotNull
    private static String calcTabName(@NotNull ContentManager cm, @NotNull List<VirtualFile> roots) {
        String name = "Log (" + roots.get(0).getName();
        if (roots.size() > 1) {
            name = name + "+";
        }
        String candidate = name = name + ")";
        int cnt = 1;
        while (GitShowExternalLogAction.hasContentsWithName(cm, candidate)) {
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    private static boolean hasContentsWithName(@NotNull ContentManager cm, @NotNull String candidate) {
        return ContainerUtil.exists((Object[])cm.getContents(), content -> content.getDisplayName().equals(candidate));
    }

    @NotNull
    private static List<VirtualFile> getGitRootsFromUser(@NotNull Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList correctRoots = ContainerUtil.newArrayList();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) continue;
            correctRoots.add(vf);
        }
        return correctRoots;
    }

    private static boolean checkIfProjectLogMatches(@NotNull Project project, @NotNull GitVcs vcs, @NotNull ContentManager cm, @NotNull List<VirtualFile> requestedRoots) {
        VirtualFile[] projectRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (Comparing.haveEqualElements(requestedRoots, Arrays.asList(projectRoots))) {
            Content[] contents;
            for (Content content : contents = cm.getContents()) {
                if (!"Log".equals(content.getDisplayName())) continue;
                cm.setSelectedContent(content);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfAlreadyOpened(@NotNull ContentManager cm, @NotNull Collection<VirtualFile> roots) {
        for (Content content : cm.getContents()) {
            JComponent component = content.getComponent();
            if (!(component instanceof MyContentComponent) || !Comparing.haveEqualElements(roots, (Collection)((MyContentComponent)component).myRoots)) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    private static class ShowLogInDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final GitVcs myVcs;
        private GitVersion myVersion;

        private ShowLogInDialogTask(@NotNull Project project, @NotNull List<VirtualFile> roots, @NotNull GitVcs vcs) {
            super(project, "Loading Git Log...", true);
            this.myProject = project;
            this.myRoots = roots;
            this.myVcs = vcs;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.myVersion = this.myVcs.getVersion();
            if (this.myVersion.isNull()) {
                this.myVcs.checkVersion();
                this.myVersion = this.myVcs.getVersion();
            }
        }

        public void onSuccess() {
            if (!this.myVersion.isNull() && !this.myProject.isDisposed()) {
                MyContentComponent content = GitShowExternalLogAction.createManagerAndContent(this.myProject, this.myVcs, this.myRoots, null);
                WindowWrapper window = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, (JComponent)content).setProject(this.myProject).setTitle("Git Log").setPreferredFocusedComponent((JComponent)content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
                Disposer.register((Disposable)window, (Disposable)content.myDisposable);
                window.show();
            }
        }
    }

    private static class MyContentComponent
    extends JPanel {
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final Disposable myDisposable;

        MyContentComponent(@NotNull JComponent actualComponent, @NotNull Collection<VirtualFile> roots, @NotNull Disposable disposable) {
            super(new BorderLayout());
            this.myDisposable = disposable;
            this.myRoots = roots;
            this.add(actualComponent);
        }
    }
}

