/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import org.apache.xmlrpc.DefaultXmlRpcTransportFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRebaseEditorMain {
    @NonNls
    @NotNull
    public static final String IDEA_REBASE_HANDER_NO = "IDEA_REBASE_HANDER_NO";
    @NonNls
    @NotNull
    public static final String GIT_REBASE_TOKEN_ENV = "GIT_REBASE_TOKEN";
    public static final int ERROR_EXIT_CODE = 2;
    @NonNls
    static final String HANDLER_NAME = "Git4ideaRebaseEditorHandler";
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    private GitRebaseEditorMain() {
    }

    public static void main(String[] args) {
        int port;
        if (args.length != 2) {
            System.err.println("Invalid amount of arguments: " + Arrays.asList(args));
            System.exit(2);
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            System.err.println("Invalid port number: " + args[0]);
            System.exit(2);
            return;
        }
        String handlerId = System.getenv(IDEA_REBASE_HANDER_NO);
        if (handlerId == null) {
            System.err.println("Handler no is not specified");
            System.exit(2);
        }
        String file = args[1];
        try {
            String token = System.getenv(GIT_REBASE_TOKEN_ENV);
            URL url = new URL("http", "localhost", port, "/RPC2");
            DefaultXmlRpcTransportFactory factory = new DefaultXmlRpcTransportFactory(url);
            factory.setBasicAuthentication("_token_", token);
            XmlRpcClient client = new XmlRpcClient(url, (XmlRpcTransportFactory)factory);
            Vector<String> params = new Vector<String>();
            params.add(handlerId);
            if (System.getProperty("os.name").toLowerCase().startsWith("windows") && file.startsWith(CYGDRIVE_PREFIX)) {
                int p = CYGDRIVE_PREFIX.length();
                file = file.substring(p, p + 1) + ":" + file.substring(p + 1);
            }
            params.add(new File(file).getAbsolutePath());
            Integer exitCode = (Integer)client.execute("Git4ideaRebaseEditorHandler.editCommits", params);
            if (exitCode == null) {
                exitCode = 2;
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("Unable to contact IDEA: " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }
}

