/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GitRebaseUnstructuredEditor
extends DialogWrapper {
    @NotNull
    private final String myEncoding;
    @NotNull
    private final File myFile;
    @NotNull
    private final JBLabel myRootLabel;
    @NotNull
    private final EditorTextField myTextEditor;

    protected GitRebaseUnstructuredEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rebaseFilePath) throws IOException {
        super(project, true);
        this.setTitle(GitBundle.message("rebase.unstructured.editor.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("rebase.unstructured.editor.button", new Object[0]));
        this.myRootLabel = new JBLabel("Git Root: " + root.getPresentableUrl());
        this.myEncoding = GitConfigUtil.getCommitEncoding(project, root);
        this.myFile = new File(rebaseFilePath);
        String text = FileUtil.loadFile((File)this.myFile, (String)this.myEncoding);
        this.myTextEditor = CommitMessage.createCommitTextEditor((Project)project, (boolean)false);
        this.myTextEditor.setText(text);
        this.myTextEditor.setCaretPosition(0);
        this.init();
    }

    public void save() throws IOException {
        FileUtil.writeToFile((File)this.myFile, (byte[])this.myTextEditor.getText().getBytes(this.myEncoding));
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel rootPanel = JBUI.Panels.simplePanel((int)10, (int)4);
        rootPanel.addToTop((Component)this.myRootLabel);
        rootPanel.addToCenter((Component)this.myTextEditor.getComponent());
        return rootPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTextEditor.getFocusTarget();
    }
}

