/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryFiles {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.repo.GitRepositoryFiles");
    private static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    private static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    private static final String CONFIG = "config";
    private static final String HEAD = "HEAD";
    private static final String INDEX = "index";
    private static final String INFO = "info";
    private static final String INFO_EXCLUDE = "info/exclude";
    private static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String MERGE_MSG = "MERGE_MSG";
    private static final String ORIG_HEAD = "ORIG_HEAD";
    private static final String REBASE_APPLY = "rebase-apply";
    private static final String REBASE_MERGE = "rebase-merge";
    private static final String PACKED_REFS = "packed-refs";
    private static final String REFS = "refs";
    private static final String HEADS = "heads";
    private static final String TAGS = "tags";
    private static final String REMOTES = "remotes";
    private static final String SQUASH_MSG = "SQUASH_MSG";
    private final VirtualFile myMainDir;
    private final VirtualFile myWorktreeDir;
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myCherryPickHeadPath;
    private final String myOrigHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myRefsTagsPath;
    private final String myCommitMessagePath;
    private final String myMergeMessagePath;
    private final String myMergeSquashPath;
    private final String myInfoDirPath;
    private final String myExcludePath;

    private GitRepositoryFiles(@NotNull VirtualFile mainDir, @NotNull VirtualFile worktreeDir) {
        this.myMainDir = mainDir;
        this.myWorktreeDir = worktreeDir;
        String mainPath = this.myMainDir.getPath();
        this.myConfigFilePath = mainPath + GitRepositoryFiles.slash(CONFIG);
        this.myPackedRefsPath = mainPath + GitRepositoryFiles.slash(PACKED_REFS);
        String refsPath = mainPath + GitRepositoryFiles.slash(REFS);
        this.myRefsHeadsDirPath = refsPath + GitRepositoryFiles.slash(HEADS);
        this.myRefsTagsPath = refsPath + GitRepositoryFiles.slash(TAGS);
        this.myRefsRemotesDirPath = refsPath + GitRepositoryFiles.slash(REMOTES);
        this.myInfoDirPath = mainPath + GitRepositoryFiles.slash(INFO);
        this.myExcludePath = mainPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
        String worktreePath = this.myWorktreeDir.getPath();
        this.myHeadFilePath = worktreePath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = worktreePath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = worktreePath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCherryPickHeadPath = worktreePath + GitRepositoryFiles.slash(CHERRY_PICK_HEAD);
        this.myOrigHeadPath = worktreePath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = worktreePath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myMergeMessagePath = worktreePath + GitRepositoryFiles.slash(MERGE_MSG);
        this.myMergeSquashPath = worktreePath + GitRepositoryFiles.slash(SQUASH_MSG);
        this.myRebaseApplyPath = worktreePath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = worktreePath + GitRepositoryFiles.slash(REBASE_MERGE);
    }

    @NotNull
    public static GitRepositoryFiles getInstance(@NotNull VirtualFile gitDir) {
        VirtualFile gitDirForWorktree = GitRepositoryFiles.getMainGitDirForWorktree(gitDir);
        VirtualFile mainDir = gitDirForWorktree == null ? gitDir : gitDirForWorktree;
        return new GitRepositoryFiles(mainDir, gitDir);
    }

    @Nullable
    private static VirtualFile getMainGitDirForWorktree(@NotNull VirtualFile gitDir) {
        String pathToMain;
        File gitDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)gitDir);
        File commonDir = new File(gitDirFile, "commondir");
        if (!commonDir.exists()) {
            return null;
        }
        try {
            pathToMain = FileUtil.loadFile((File)commonDir).trim();
        }
        catch (IOException e) {
            LOG.error("Couldn't load " + commonDir, (Throwable)e);
            return null;
        }
        String mainDir = FileUtil.toCanonicalPath((String)(gitDirFile.getPath() + File.separator + pathToMain), (boolean)true);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile mainDirVF = lfs.refreshAndFindFileByPath(mainDir);
        if (mainDirVF != null) {
            return mainDirVF;
        }
        return lfs.refreshAndFindFileByPath(pathToMain);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        return "/" + s;
    }

    @NotNull
    Collection<String> getDirsToWatch() {
        return Arrays.asList(this.myRefsHeadsDirPath, this.myRefsRemotesDirPath, this.myRefsTagsPath, this.myInfoDirPath);
    }

    @NotNull
    File getRefsHeadsFile() {
        return GitRepositoryFiles.file(this.myRefsHeadsDirPath);
    }

    @NotNull
    File getRefsRemotesFile() {
        return GitRepositoryFiles.file(this.myRefsRemotesDirPath);
    }

    @NotNull
    File getRefsTagsFile() {
        return GitRepositoryFiles.file(this.myRefsTagsPath);
    }

    @NotNull
    File getPackedRefsPath() {
        return GitRepositoryFiles.file(this.myPackedRefsPath);
    }

    @NotNull
    public File getHeadFile() {
        return GitRepositoryFiles.file(this.myHeadFilePath);
    }

    @NotNull
    File getConfigFile() {
        return GitRepositoryFiles.file(this.myConfigFilePath);
    }

    @NotNull
    public File getRebaseMergeDir() {
        return GitRepositoryFiles.file(this.myRebaseMergePath);
    }

    @NotNull
    public File getRebaseApplyDir() {
        return GitRepositoryFiles.file(this.myRebaseApplyPath);
    }

    @NotNull
    public File getMergeHeadFile() {
        return GitRepositoryFiles.file(this.myMergeHeadPath);
    }

    @NotNull
    public File getCherryPickHead() {
        return GitRepositoryFiles.file(this.myCherryPickHeadPath);
    }

    @NotNull
    public File getMergeMessageFile() {
        return GitRepositoryFiles.file(this.myMergeMessagePath);
    }

    @NotNull
    public File getSquashMessageFile() {
        return GitRepositoryFiles.file(this.myMergeSquashPath);
    }

    @NotNull
    private static File file(@NotNull String filePath) {
        return new File(FileUtil.toSystemDependentName((String)filePath));
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file) {
        return file.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        return FileUtil.pathsEqual((String)filePath, (String)(this.myMainDir.getPath() + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        return path.equals(this.myExcludePath);
    }

    public void refresh(boolean async) {
        VfsUtil.markDirtyAndRefresh((boolean)async, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }

    @NotNull
    Collection<VirtualFile> getRootDirs() {
        return ContainerUtil.newHashSet((Object[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }
}

