/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitUntrackedFilesHolder;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    private GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean light) {
        super(project, rootDir, parentDisposable);
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.myGitDir = gitDir;
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        this.myReader = new GitRepositoryReader(this.myRepositoryFiles);
        this.myInfo = this.readRepoInfo();
        if (!light) {
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this, this.myRepositoryFiles);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
        } else {
            this.myUntrackedFilesHolder = null;
        }
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        return GitRepositoryImpl.getInstance(root, (VirtualFile)ObjectUtils.assertNotNull((Object)GitUtil.findGitDir(root)), project, listenToRepoChanges);
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, boolean listenToRepoChanges) {
        GitRepositoryImpl repository = new GitRepositoryImpl(root, gitDir, project, (Disposable)project, !listenToRepoChanges);
        if (listenToRepoChanges) {
            repository.getUntrackedFilesHolder().setupVfsListener(project);
            repository.setupUpdater();
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
        return repository;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this, this.myRepositoryFiles);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    @Deprecated
    @NotNull
    public VirtualFile getGitDir() {
        return this.myGitDir;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        return this.myRepositoryFiles;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        return this.myUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        return this.myInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        return this.myInfo.getState();
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        return this.myVcs;
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        return new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes());
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        return this.myInfo.getRemotes();
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.myInfo.getBranchTrackInfos();
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public void update() {
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyIfRepoChanged(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        File configFile = this.myRepositoryFiles.getConfigFile();
        GitConfig config = GitConfig.read(configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches().keySet(), state.getRemoteBranches().keySet());
        return new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), remotes, state.getLocalBranches(), state.getRemoteBranches(), trackInfos);
    }

    private static void notifyIfRepoChanged(@NotNull GitRepository repository, @NotNull GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        if (!repository.getProject().isDisposed() && !info.equals(previousInfo)) {
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
    }

    private static void notifyListenersAsync(final @NotNull GitRepository repository) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Project project = repository.getProject();
                if (!project.isDisposed()) {
                    ((GitRepositoryChangeListener)project.getMessageBus().syncPublisher(GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository);
                }
            }
        });
    }

    @NotNull
    public String toLogString() {
        return "GitRepository " + this.getRoot() + " : " + this.myInfo;
    }
}

