/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import git4idea.validators.GitRefNameValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    private static final Processor<File> NOT_HIDDEN_DIRECTORIES = new Processor<File>(){

        public boolean process(File dir) {
            return !GitRepositoryReader.isHidden(dir);
        }
    };
    private static Pattern BRANCH_PATTERN = Pattern.compile(" *(?:ref:)? */?((?:refs/heads/|refs/remotes/)?\\S+)");
    @NonNls
    private static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    private static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        DvcsUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found at " + this.myHeadFile));
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches = this.readBranches(remotes);
        Map localBranches = (Map)branches.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state, localBranches.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.error("Couldn't identify neither current branch nor current revision. .git/HEAD content: [" + headInfo.content + "]");
        }
        return new GitBranchState(currentRevision, currentBranch, state, localBranches, (Map)branches.second);
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state, @NotNull Set<GitLocalBranch> localBranches) {
        final String currentBranchName = this.findCurrentBranchName(state, headInfo);
        if (currentBranchName == null) {
            return null;
        }
        return (GitLocalBranch)ContainerUtil.find(localBranches, (Condition)new Condition<GitLocalBranch>(){

            public boolean value(GitLocalBranch branch) {
                return GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getFullName(), (Object)currentBranchName);
            }
        });
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (this.isMergeInProgress()) {
            return Repository.State.MERGING;
        }
        if (this.isRebaseInProgress()) {
            return Repository.State.REBASING;
        }
        if (!headInfo.isBranch) {
            return Repository.State.DETACHED;
        }
        return Repository.State.NORMAL;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state, @NotNull HeadInfo headInfo) {
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state == Repository.State.REBASING && (currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir())) == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return GitRepositoryReader.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    @Nullable
    private static String addRefsHeadsPrefixIfNeeded(@Nullable String branchName) {
        if (branchName != null && !branchName.startsWith(REFS_HEADS_PREFIX)) {
            return REFS_HEADS_PREFIX + branchName;
        }
        return branchName;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        if (!this.myPackedRefsFile.exists()) {
            return Collections.emptyMap();
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            return ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), (Function)new Function<String, Pair<String, String>>(){

                public Pair<String, String> fun(String line) {
                    return GitRepositoryReader.parsePackedRefsLine(line);
                }
            });
        }
        catch (RepoStateException e) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        Map<String, String> data = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRepositoryReader.resolveRefs(data);
        return GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        HashMap result = ContainerUtil.newHashMap(this.readPackedBranches());
        result.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsHeadsDir, REFS_HEADS_PREFIX));
        result.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsRemotesDir, REFS_REMOTES_PREFIX));
        result.remove("refs/remotes/origin/HEAD");
        return result;
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data) {
        HashMap localBranches = ContainerUtil.newHashMap();
        HashMap remoteBranches = ContainerUtil.newHashMap();
        for (Map.Entry<String, Hash> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            if (refName.startsWith(REFS_HEADS_PREFIX)) {
                localBranches.put(new GitLocalBranch(refName), hash);
                continue;
            }
            if (refName.startsWith(REFS_REMOTES_PREFIX)) {
                GitRemoteBranch remoteBranch = GitRepositoryReader.parseRemoteBranch(refName, remotes);
                if (remoteBranch == null) continue;
                remoteBranches.put(remoteBranch, hash);
                continue;
            }
            LOG.warn("Unexpected ref format: " + refName);
        }
        return Pair.create((Object)localBranches, (Object)remoteBranches);
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private static Map<String, String> readFromBranchFiles(final @NotNull File refsRootDir, final @NotNull String prefix) {
        if (!refsRootDir.exists()) {
            return Collections.emptyMap();
        }
        final HashMap<String, String> result = new HashMap<String, String>();
        FileUtil.processFilesRecursively((File)refsRootDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!file.isDirectory() && !GitRepositoryReader.isHidden(file) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file)) != null) {
                    String hash;
                    String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                    boolean isBranchNameValid = GitRefNameValidator.getInstance().checkInput(branchName);
                    if (isBranchNameValid && (hash = GitRepositoryReader.loadHashFromBranchFile(file)) != null) {
                        result.put(branchName, hash);
                    }
                }
                return true;
            }
        }, NOT_HIDDEN_DIRECTORIES);
        return result;
    }

    private static boolean isHidden(@NotNull File file) {
        return file.getName().startsWith(".");
    }

    @Nullable
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName);
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            LOG.debug(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, ContainerUtil.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName);
        }
        return new GitStandardRemoteBranch(remote, branchName);
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return new HeadInfo(false, null);
        }
        Hash hash = GitRepositoryReader.parseHash(headContent);
        if (hash != null) {
            return new HeadInfo(false, headContent);
        }
        String target = GitRepositoryReader.getTarget(headContent);
        if (target != null) {
            return new HeadInfo(true, target);
        }
        LOG.error((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        return new HeadInfo(false, null);
    }

    @Nullable
    private static Pair<String, String> parsePackedRefsLine(@NotNull String line) {
        int i;
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i;
        if (start < line.length() && line.charAt(start++) == ' ') {
            char c;
            for (i = start; i < line.length() && !Character.isWhitespace(c = line.charAt(i)); ++i) {
            }
            branch = line.substring(start, i);
        }
        if (branch == null || !branch.startsWith(REFS_HEADS_PREFIX) && !branch.startsWith(REFS_REMOTES_PREFIX)) {
            return null;
        }
        return Pair.create((Object)GitRepositoryReader.shortBuffer(branch), (Object)GitRepositoryReader.shortBuffer(hash.trim()));
    }

    @NotNull
    private static String shortBuffer(String raw) {
        return new String(raw);
    }

    @NotNull
    private static Map<String, Hash> resolveRefs(@NotNull Map<String, String> data) {
        final Map<String, Hash> resolved = GitRepositoryReader.getResolvedHashes(data);
        Map unresolved = ContainerUtil.filter(data, (Condition)new Condition<String>(){

            public boolean value(String refName) {
                return !resolved.containsKey(refName);
            }
        });
        boolean progressed = true;
        while (progressed && !unresolved.isEmpty()) {
            progressed = false;
            Iterator iterator = unresolved.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String refName = (String)entry.getKey();
                String refValue = (String)entry.getValue();
                String link = GitRepositoryReader.getTarget(refValue);
                if (link != null) {
                    if (GitRepositoryReader.duplicateEntry(resolved, refName, refValue)) {
                        iterator.remove();
                        continue;
                    }
                    if (!resolved.containsKey(link)) {
                        LOG.debug("Unresolved symbolic link [" + refName + "] pointing to [" + refValue + "]");
                        continue;
                    }
                    Hash targetValue = resolved.get(link);
                    resolved.put(refName, targetValue);
                    iterator.remove();
                    progressed = true;
                    continue;
                }
                LOG.warn("Unexpected record [" + refName + "] -> [" + refValue + "]");
                iterator.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            LOG.warn("Cyclic symbolic links among .git/refs: " + unresolved);
        }
        return resolved;
    }

    @NotNull
    private static Map<String, Hash> getResolvedHashes(@NotNull Map<String, String> data) {
        HashMap resolved = ContainerUtil.newHashMap();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = GitRepositoryReader.parseHash(entry.getValue());
            if (hash == null || GitRepositoryReader.duplicateEntry(resolved, refName, hash)) continue;
            resolved.put(refName, hash);
        }
        return resolved;
    }

    @Nullable
    private static String getTarget(@NotNull String refName) {
        Matcher matcher = BRANCH_PATTERN.matcher(refName);
        if (!matcher.matches()) {
            return null;
        }
        String target = matcher.group(1);
        if (!target.startsWith(REFS_HEADS_PREFIX) && !target.startsWith(REFS_REMOTES_PREFIX)) {
            target = REFS_HEADS_PREFIX + target;
        }
        return target;
    }

    @Nullable
    private static Hash parseHash(@NotNull String value) {
        try {
            return HashImpl.build((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean duplicateEntry(@NotNull Map<String, Hash> resolved, @NotNull String refName, @NotNull Object newValue) {
        if (resolved.containsKey(refName)) {
            LOG.error("Duplicate entry for [" + refName + "]. resolved: [" + resolved.get(refName).asString() + "], current: " + newValue + "]");
            return true;
        }
        return false;
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

