/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.roots.VcsIntegrationEnabler;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import org.jetbrains.annotations.NotNull;

public class GitIntegrationEnabler
extends VcsIntegrationEnabler {
    private static final Logger LOG = Logger.getInstance(GitIntegrationEnabler.class);
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitVcs myVcs;

    public GitIntegrationEnabler(@NotNull GitVcs vcs, @NotNull Git git) {
        super((AbstractVcs)vcs);
        this.myVcs = vcs;
        this.myGit = git;
    }

    protected boolean initOrNotifyError(@NotNull VirtualFile projectDir) {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        GitCommandResult result = this.myGit.init(this.myProject, projectDir, new GitLineHandlerListener[0]);
        if (result.success()) {
            GitIntegrationEnabler.refreshVcsDir((VirtualFile)projectDir, (String)".git");
            vcsNotifier.notifySuccess("Created Git repository in " + projectDir.getPresentableUrl());
            return true;
        }
        if (this.myVcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            vcsNotifier.notifyError("Couldn't git init " + projectDir.getPresentableUrl(), result.getErrorOutputAsHtmlString());
            LOG.info(result.getErrorOutputAsHtmlString());
        }
        return false;
    }
}

