/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class GitChangesCollector {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VirtualFile myVcsRoot;
    @NotNull
    private final VcsDirtyScope myDirtyScope;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private AbstractVcs myVcs;

    GitChangesCollector(@NotNull Project project, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull VirtualFile vcsRoot) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myVcsManager = vcsManager;
        this.myVcs = vcs;
        this.myDirtyScope = dirtyScope;
        this.myVcsRoot = vcsRoot;
    }

    @NotNull
    abstract Collection<VirtualFile> getUnversionedFiles();

    @NotNull
    abstract Collection<Change> getChanges();

    protected Collection<FilePath> dirtyPaths(boolean includeChanges) {
        ArrayList<String> allPaths = new ArrayList<String>();
        for (FilePath p : this.myDirtyScope.getRecursivelyDirtyDirectories()) {
            this.addToPaths(p, allPaths);
        }
        for (FilePath p : this.myDirtyScope.getDirtyFilesNoExpand()) {
            this.addToPaths(p, allPaths);
        }
        if (includeChanges) {
            for (Change c : this.myChangeListManager.getChangesIn(this.myVcsRoot)) {
                switch (c.getType()) {
                    case NEW: 
                    case DELETED: 
                    case MOVED: {
                        ContentRevision beforeRevision;
                        ContentRevision afterRevision = c.getAfterRevision();
                        if (afterRevision != null) {
                            this.addToPaths(afterRevision.getFile(), allPaths);
                        }
                        if ((beforeRevision = c.getBeforeRevision()) == null) break;
                        this.addToPaths(beforeRevision.getFile(), allPaths);
                    }
                }
            }
        }
        GitChangesCollector.removeCommonParents(allPaths);
        return ContainerUtil.map(allPaths, VcsUtil::getFilePath);
    }

    protected void addToPaths(FilePath pathToAdd, List<String> paths) {
        VcsRoot fileRoot = this.myVcsManager.getVcsRootObjectFor(pathToAdd);
        if (fileRoot != null && fileRoot.getVcs() != null && this.myVcs.equals((Object)fileRoot.getVcs()) && this.myVcsRoot.equals(fileRoot.getPath())) {
            paths.add(pathToAdd.getPath());
        }
    }

    protected static void removeCommonParents(List<String> allPaths) {
        Collections.sort(allPaths);
        String prevPath = null;
        Iterator<String> it = allPaths.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (prevPath != null && FileUtil.startsWith((String)path, (String)prevPath, (boolean)true)) {
                it.remove();
                continue;
            }
            prevPath = path;
        }
    }
}

