/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserWithRollback
extends ChangesBrowser {
    private final List<Change> myOriginalChanges;

    public ChangesBrowserWithRollback(@NotNull Project project, @NotNull List<Change> changes) {
        super(project, null, changes, null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myOriginalChanges = changes;
        RollbackDialogAction rollback = new RollbackDialogAction();
        rollback.registerCustomShortcutSet((JComponent)((Object)this), null);
        this.addToolbarAction((AnAction)rollback);
        this.setChangesToDisplay(changes);
    }

    public void rebuildList() {
        if (this.myOriginalChanges != null) {
            this.myChangesToDisplay = ChangesBrowserWithRollback.filterActualChanges(this.myProject, this.myOriginalChanges);
        }
        super.rebuildList();
    }

    @NotNull
    private static List<Change> filterActualChanges(@NotNull Project project, @NotNull List<Change> originalChanges) {
        final Collection allChanges = ChangeListManager.getInstance((Project)project).getAllChanges();
        return ContainerUtil.filter(originalChanges, (Condition)new Condition<Change>(){

            public boolean value(Change change) {
                return allChanges.contains(change);
            }
        });
    }
}

