/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchType;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchManager {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    public final BranchStorage myPredefinedFavoriteBranches = new BranchStorage();

    public GitBranchManager(@NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings settings) {
        this.myRepositoryManager = repositoryManager;
        this.mySettings = settings;
        for (GitBranchType type : GitBranchType.values()) {
            this.myPredefinedFavoriteBranches.myBranches.put(type.toString(), this.constructDefaultBranchPredefinedList(type));
        }
    }

    @NotNull
    private List<DvcsBranchInfo> constructDefaultBranchPredefinedList(GitBranchType type) {
        ArrayList branchInfos = ContainerUtil.newArrayList((Object[])new DvcsBranchInfo[]{new DvcsBranchInfo("", GitBranchManager.getDefaultBranchName(type))});
        branchInfos.addAll(ContainerUtil.map2List(this.myRepositoryManager.getRepositories(), repository -> new DvcsBranchInfo(repository.getRoot().getPath(), GitBranchManager.getDefaultBranchName(type))));
        return branchInfos;
    }

    @NotNull
    private static String getDefaultBranchName(@NotNull GitBranchType type) {
        return type == GitBranchType.LOCAL ? "master" : "origin/master";
    }

    public boolean isFavorite(@NotNull GitBranchType branchType, @Nullable GitRepository repository, @NotNull String branchName) {
        if (this.mySettings.isFavorite(branchType, repository, branchName)) {
            return true;
        }
        if (this.mySettings.isExcludedFromFavorites(branchType, repository, branchName)) {
            return false;
        }
        return this.myPredefinedFavoriteBranches.contains(branchType.toString(), (Repository)repository, branchName);
    }

    public void setFavorite(@NotNull GitBranchType branchType, @Nullable GitRepository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (shouldBeFavorite) {
            this.mySettings.addToFavorites(branchType, repository, branchName);
            this.mySettings.removeFromExcluded(branchType, repository, branchName);
        } else if (this.mySettings.isFavorite(branchType, repository, branchName)) {
            this.mySettings.removeFromFavorites(branchType, repository, branchName);
        } else if (this.myPredefinedFavoriteBranches.contains(branchType.toString(), (Repository)repository, branchName)) {
            this.mySettings.excludedFromFavorites(branchType, repository, branchName);
        }
    }
}

