/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitStatisticsCollectorKt;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, "", false);
    }

    ActionGroup createActions(@Nullable DefaultActionGroup toInsert, @NotNull String repoInfo, boolean firstLevelGroup) {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Local Branches" + repoInfo);
        List localBranchActions = this.myRepository.getBranches().getLocalBranches().stream().sorted().filter(branch -> !branch.equals(this.myRepository.getCurrentBranch())).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)ContainerUtil.sorted(localBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches(localBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator("Remote Branches" + repoInfo);
        List remoteBranchActions = this.myRepository.getBranches().getRemoteBranches().stream().sorted().map(remoteBranch -> new RemoteBranchActions(this.myProject, repositoryList, remoteBranch.getName(), this.myRepository)).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)ContainerUtil.sorted(remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfFavorites(remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            super("Checkout with Rebase", "Checkout the given branch, and rebase it on current branch in one step, just like `git rebase HEAD " + branchName + "` would do.", null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
            GitStatisticsCollectorKt.reportUsage("git.branch.checkout.with.rebase");
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public RebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            super("Rebase onto");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
            GitStatisticsCollectorKt.reportUsage("git.branch.rebase");
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        public MergeAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            super("Merge");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
            GitStatisticsCollectorKt.reportUsage("git.branch.merge");
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final GitRepository mySelectedRepository;

        public CompareAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            super("Compare");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories, this.mySelectedRepository);
            GitStatisticsCollectorKt.reportUsage("git.branch.compare");
        }
    }

    static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        RemoteBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)ServiceManager.getService((Project)project, GitBranchManager.class);
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
                GitStatisticsCollectorKt.reportUsage("git.branch.delete.remote");
            }
        }

        static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myRemoteBranchName;

            public CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String remoteBranchName) {
                super("Checkout as new local branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)"Checkout Remote Branch", null, (String)this.guessBranchName(), (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myRemoteBranchName, this.myRepositories, null);
                    GitStatisticsCollectorKt.reportUsage("git.branch.checkout.remote");
                }
            }

            private String guessBranchName() {
                int slashPosition = this.myRemoteBranchName.indexOf("/");
                return this.myRemoteBranchName.substring(slashPosition + 1);
            }
        }
    }

    static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;

        LocalBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)ServiceManager.getService((Project)project, GitBranchManager.class);
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        private String calcBranchText() {
            return this.myBranchName;
        }

        @NotNull
        List<GitRepository> getRepositories() {
            return this.myRepositories;
        }

        @NotNull
        public String getBranchName() {
            return this.myBranchName;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteBranch(this.myBranchName, this.myRepositories);
                GitStatisticsCollectorKt.reportUsage("git.branch.delete.local");
            }
        }

        private static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            public RenameBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String currentBranchName) {
                super("Rename");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String newName = Messages.showInputDialog((Project)this.myProject, (String)("New name for the branch '" + this.myCurrentBranchName + "':"), (String)("Rename Branch " + this.myCurrentBranchName), null, (String)this.myCurrentBranchName, (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (newName != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.renameBranch(this.myCurrentBranchName, newName, this.myRepositories);
                    GitStatisticsCollectorKt.reportUsage("git.branch.rename");
                }
            }
        }

        private static class CheckoutAsNewBranch
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAsNewBranch(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Checkout as New Branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)("Checkout New Branch From " + this.myBranchName), null, (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myBranchName, this.myRepositories, null);
                }
                GitStatisticsCollectorKt.reportUsage("git.checkout.as.new.branch");
            }
        }

        static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Checkout");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(this.myBranchName, false, this.myRepositories, null);
                GitStatisticsCollectorKt.reportUsage("git.branch.checkout.local");
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super("Checkout Tag or Revision...");
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(AnActionEvent e) {
            String reference = Messages.showInputDialog((Project)this.myProject, (String)"Enter reference (branch, tag) name or commit hash:", (String)"Checkout", null);
            if (reference != null) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
                GitStatisticsCollectorKt.reportUsage("git.branch.checkout.revision");
            }
        }

        public void update(AnActionEvent e) {
            boolean isFresh = ContainerUtil.and(this.myRepositories, repository -> repository.isFresh());
            if (isFresh) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout is not possible before the first commit");
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            super(project, repositories);
        }

        public void actionPerformed(AnActionEvent e) {
            GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(this.myProject, this.myRepositories, "Create New Branch");
            if (options != null) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                if (options.shouldCheckout()) {
                    GitStatisticsCollectorKt.reportUsage("git.branch.create.new");
                    brancher.checkoutNewBranch(options.getName(), this.myRepositories);
                } else {
                    GitStatisticsCollectorKt.reportUsage("git.branch.create.new.nocheckout");
                    brancher.createBranch(options.getName(), StreamEx.of((Collection)this.myRepositories).toMap(position -> "HEAD"));
                }
            }
        }
    }
}

