/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ObjectUtils;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        super(project, "Git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget((Project)ObjectUtils.assertNotNull((Object)this.getProject()));
    }

    @Nullable
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)this.mySettings.getRecentRootPath());
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        return GitBranchUtil.getDisplayableBranchText(repository);
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        return GitBranchPopup.getInstance(project, repository).asListPopup();
    }

    protected void subscribeToRepoChangeEvents(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                LOG.debug("repository changed");
                GitBranchWidget.this.updateLater();
            }
        });
    }

    protected void rememberRecentRoot(@NotNull String path) {
        this.mySettings.setRecentRoot(path);
    }
}

