/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListPanel;
import git4idea.ui.GitRepositoryComboboxListCellRenderer;
import git4idea.util.GitCommitCompareInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class GitCompareBranchesLogPanel
extends JPanel {
    private final Project myProject;
    private final String myBranchName;
    private final String myCurrentBranchName;
    private final GitCommitCompareInfo myCompareInfo;
    private final GitRepository myInitialRepo;
    private GitCommitListPanel myHeadToBranchListPanel;
    private GitCommitListPanel myBranchToHeadListPanel;

    GitCompareBranchesLogPanel(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo) {
        super(new BorderLayout(10, 4));
        this.myProject = project;
        this.myBranchName = branchName;
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myInitialRepo = initialRepo;
        this.add((Component)this.createNorthPanel(), "North");
        this.add(this.createCenterPanel());
    }

    private JComponent createCenterPanel() {
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        this.myHeadToBranchListPanel = new GitCommitListPanel(this.getHeadToBranchCommits(this.myInitialRepo), String.format("Branch %s is fully merged to %s", this.myBranchName, this.myCurrentBranchName));
        this.myBranchToHeadListPanel = new GitCommitListPanel(this.getBranchToHeadCommits(this.myInitialRepo), String.format("Branch %s is fully merged to %s", this.myCurrentBranchName, this.myBranchName));
        GitCompareBranchesLogPanel.addSelectionListener(this.myHeadToBranchListPanel, this.myBranchToHeadListPanel, changesBrowser);
        GitCompareBranchesLogPanel.addSelectionListener(this.myBranchToHeadListPanel, this.myHeadToBranchListPanel, changesBrowser);
        this.myHeadToBranchListPanel.registerDiffAction(changesBrowser.getDiffAction());
        this.myBranchToHeadListPanel.registerDiffAction(changesBrowser.getDiffAction());
        JPanel htb = this.layoutCommitListPanel(this.myCurrentBranchName, true);
        JPanel bth = this.layoutCommitListPanel(this.myCurrentBranchName, false);
        JPanel listPanel = null;
        switch (this.getInfoType()) {
            case HEAD_TO_BRANCH: {
                listPanel = htb;
                break;
            }
            case BRANCH_TO_HEAD: {
                listPanel = bth;
                break;
            }
            case BOTH: {
                Splitter lists = new Splitter(true, 0.5f);
                lists.setFirstComponent((JComponent)htb);
                lists.setSecondComponent((JComponent)bth);
                listPanel = lists;
            }
        }
        Splitter rootPanel = new Splitter(false, 0.7f);
        rootPanel.setSecondComponent((JComponent)changesBrowser);
        rootPanel.setFirstComponent((JComponent)listPanel);
        return rootPanel;
    }

    private JComponent createNorthPanel() {
        final JComboBox<Object> repoSelector = new JComboBox<Object>(ArrayUtil.toObjectArray(this.myCompareInfo.getRepositories(), GitRepository.class));
        repoSelector.setRenderer((ListCellRenderer<Object>)((Object)new GitRepositoryComboboxListCellRenderer(repoSelector)));
        repoSelector.setSelectedItem(this.myInitialRepo);
        repoSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRepository selectedRepo = (GitRepository)repoSelector.getSelectedItem();
                GitCompareBranchesLogPanel.this.myHeadToBranchListPanel.setCommits(GitCompareBranchesLogPanel.this.getHeadToBranchCommits(selectedRepo));
                GitCompareBranchesLogPanel.this.myBranchToHeadListPanel.setCommits(GitCompareBranchesLogPanel.this.getBranchToHeadCommits(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new FlowLayout(0, 0, 0));
        JBLabel label = new JBLabel("Repository: ");
        label.setLabelFor((Component)repoSelectorPanel);
        label.setDisplayedMnemonic(82);
        repoSelectorPanel.add((Component)label);
        repoSelectorPanel.add(repoSelector);
        if (this.myCompareInfo.getRepositories().size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        return repoSelectorPanel;
    }

    private ArrayList<GitCommit> getBranchToHeadCommits(GitRepository selectedRepo) {
        return new ArrayList<GitCommit>(this.myCompareInfo.getBranchToHeadCommits(selectedRepo));
    }

    private ArrayList<GitCommit> getHeadToBranchCommits(GitRepository selectedRepo) {
        return new ArrayList<GitCommit>(this.myCompareInfo.getHeadToBranchCommits(selectedRepo));
    }

    private GitCommitCompareInfo.InfoType getInfoType() {
        return this.myCompareInfo.getInfoType();
    }

    private static void addSelectionListener(@NotNull GitCommitListPanel sourcePanel, final @NotNull GitCommitListPanel otherPanel, final @NotNull ChangesBrowser changesBrowser) {
        sourcePanel.addListMultipleSelectionListener(new Consumer<List<Change>>(){

            public void consume(List<Change> changes) {
                changesBrowser.setChangesToDisplay(changes);
                otherPanel.clearSelection();
            }
        });
    }

    private JPanel layoutCommitListPanel(@NotNull String currentBranch, boolean forward) {
        String desc = this.makeDescription(currentBranch, forward);
        JPanel bth = new JPanel(new BorderLayout());
        JBLabel descriptionLabel = new JBLabel(desc, UIUtil.ComponentStyle.SMALL);
        descriptionLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        bth.add((Component)descriptionLabel, "North");
        bth.add(forward ? this.myHeadToBranchListPanel : this.myBranchToHeadListPanel);
        return bth;
    }

    private String makeDescription(@NotNull String currentBranch, boolean forward) {
        String firstBranch = forward ? currentBranch : this.myBranchName;
        String secondBranch = forward ? this.myBranchName : currentBranch;
        return String.format("<html>Commits that exist in <code><b>%s</b></code> but don't exist in <code><b>%s</b></code> (<code>git log %s..%s</code>):</html>", secondBranch, firstBranch, firstBranch, secondBranch);
    }
}

