/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);

    private GitFileUtils() {
    }

    public static void delete(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        handler.run();
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, files, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, files);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkFiles((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> removedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(removedFiles);
    }

    public static void addFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files) throws VcsException {
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkPaths((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesFromFilePaths(@NotNull Collection<FilePath> paths) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.size());
        for (FilePath path : paths) {
            VirtualFile file = path.getVirtualFile();
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<List<String>> chunkedPaths) throws VcsException {
        for (List<String> paths : chunkedPaths) {
            if ((paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) continue;
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.ADD);
            handler.addParameters("--ignore-errors");
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = handler.run();
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        return nonIgnoredFiles;
    }

    public static byte[] getFileContent(Project project, VirtualFile root, String revisionOrBranch, String relativePath) throws VcsException {
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(revisionOrBranch + ":" + relativePath);
        h.endOptions();
        return h.run();
    }

    public static String stripFileProtocolPrefix(String path) {
        String FILE_PROTOCOL = "file://";
        if (path.startsWith("file://")) {
            return path.substring("file://".length());
        }
        return path;
    }
}

