/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHelper {
    private GitUntrackedFilesHelper() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(final @NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, final @NotNull String operation, @Nullable String description) {
        String notificationTitle = StringUtil.capitalize((String)operation) + " failed";
        String notificationDesc = description == null ? GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operation, true) : description;
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String absolutePath) {
                return GitUtil.findRefreshFileOrLog(absolutePath);
            }
        });
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, notificationDesc, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String dialogDesc = GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operation, false);
                    String title = "Untracked Files Preventing " + StringUtil.capitalize((String)operation);
                    if (untrackedFiles.isEmpty()) {
                        GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                    } else {
                        UntrackedFilesDialog dialog = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                        dialog.setTitle(title);
                        dialog.show();
                    }
                }
            }
        });
    }

    @NotNull
    public static String createUntrackedFilesOverwrittenDescription(@NotNull String operation, boolean addLinkToViewFiles) {
        String description1 = " untracked working tree files would be overwritten by " + operation + ".";
        String description2 = "Please move or remove them before you can " + operation + ".";
        String notificationDesc = addLinkToViewFiles ? "Some" + description1 + "<br/>" + description2 + " <a href='view'>View them</a>" : "These" + description1 + "<br/>" + description2;
        return notificationDesc;
    }

    public static boolean showUntrackedFilesDialogWithRollback(final @NotNull Project project, final @NotNull String operationName, final @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String absolutePath) {
                return GitUtil.findRefreshFileOrLog(absolutePath);
            }
        });
        final Ref rollback = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JComponent filesBrowser = untrackedFiles.isEmpty() ? new GitSimplePathsBrowser(project, absolutePaths) : ScrollPaneFactory.createScrollPane((Component)new SelectFilesDialog.VirtualFileList(project, untrackedFiles, false, false));
                String title = "Could not " + StringUtil.capitalize((String)operationName);
                String description = StringUtil.stripHtml((String)GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operationName, false), (boolean)true);
                UntrackedFilesRollBackDialog dialog = new UntrackedFilesRollBackDialog(project, filesBrowser, description, rollbackProposal);
                dialog.setTitle(title);
                DialogManager.show(dialog);
                rollback.set((Object)dialog.isOK());
            }
        });
        return (Boolean)rollback.get();
    }

    private static class UntrackedFilesRollBackDialog
    extends DialogWrapper {
        @NotNull
        private final JComponent myFilesBrowser;
        @NotNull
        private final String myPrompt;
        @NotNull
        private final String myRollbackProposal;

        public UntrackedFilesRollBackDialog(@NotNull Project project, @NotNull JComponent filesBrowser, @NotNull String prompt, @NotNull String rollbackProposal) {
            super(project);
            this.myFilesBrowser = filesBrowser;
            this.myPrompt = prompt;
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText("Rollback");
            this.setCancelButtonText("Don't rollback");
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            if (buttons != null) {
                panel.add(buttons);
            }
            return panel;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myFilesBrowser;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        public UntrackedFilesDialog(Project project, Collection<VirtualFile> untrackedFiles, String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, false, true);
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction()};
        }
    }
}

