/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScriptGenerator {
    public static final String SCRIPT_EXT = SystemInfo.isWindows ? ".bat" : ".sh";
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<String> myPaths = new ArrayList();
    private final ArrayList<String> myInternalParameters = new ArrayList();

    public ScriptGenerator(String prefix, Class mainClass) {
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
    }

    public ScriptGenerator addClasses(Class ... classes) {
        for (Class c : classes) {
            this.addPath(PathUtil.getJarPathForClass((Class)c));
        }
        return this;
    }

    private void addPath(String path) {
        if (!this.myPaths.contains(path)) {
            this.myPaths.add(path);
        }
    }

    public ScriptGenerator addResource(Class base, @NonNls String resource) {
        this.addPath(ScriptGenerator.getJarForResource(base, resource));
        return this;
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    @NotNull
    public File generate() throws IOException {
        String title = SystemInfo.isWindows ? "@echo off" : "#!/bin/sh";
        String parametersPassthrough = SystemInfo.isWindows ? " %*" : " \"$@\"";
        String content = title + "\n" + this.commandLine() + parametersPassthrough + "\n";
        File file = new File(PathManager.getTempPath(), this.myPrefix + SCRIPT_EXT);
        if (SystemInfo.isWindows && file.getPath().contains(" ")) {
            file = new File(FileUtil.getTempDirectory(), this.myPrefix + SCRIPT_EXT);
        }
        FileUtil.writeToFile((File)file, (String)content);
        FileUtil.setExecutableAttribute((String)file.getPath(), (boolean)true);
        return file;
    }

    public String commandLine() {
        StringBuilder cmd = new StringBuilder();
        cmd.append('\"').append(System.getProperty("java.home")).append(File.separatorChar).append("bin").append(File.separatorChar).append("java\" -cp \"");
        boolean first = true;
        for (String p : this.myPaths) {
            if (!first) {
                cmd.append(File.pathSeparatorChar);
            } else {
                first = false;
            }
            cmd.append(p);
        }
        cmd.append("\" ");
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }

    public static String getJarForResource(Class context, String res) {
        String resourceRoot = PathManager.getResourceRoot((Class)context, (String)res);
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }
}

