/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.smali;

import com.android.tools.idea.smali.SmaliHighlighterColors;
import com.android.tools.idea.smali.psi.SmaliAccessModifier;
import com.android.tools.idea.smali.psi.SmaliFieldName;
import com.android.tools.idea.smali.psi.SmaliFieldSpec;
import com.android.tools.idea.smali.psi.SmaliTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmaliAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement fieldNameElement;
        ASTNode node;
        if (element instanceof LeafPsiElement && (node = element.getNode()).getElementType().equals(SmaliTypes.IDENTIFIER) && (fieldNameElement = PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> element1 instanceof SmaliFieldName)) != null) {
            SmaliAnnotator.annotateFieldName(element, holder);
        }
    }

    private static void annotateFieldName(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement fieldSpecElement = PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> element1 instanceof SmaliFieldSpec);
        if (fieldSpecElement instanceof SmaliFieldSpec) {
            boolean isConstant;
            Annotation annotation = holder.createInfoAnnotation(element, null);
            List<SmaliAccessModifier> accessModifiers = ((SmaliFieldSpec)fieldSpecElement).getAccessModifierList();
            Set<String> accessModifierNames = SmaliAnnotator.getAccessModifierNames(accessModifiers);
            boolean isStatic = accessModifierNames.contains("static");
            boolean bl = isConstant = isStatic && accessModifierNames.contains("final");
            if (isConstant) {
                annotation.setTextAttributes(SmaliHighlighterColors.CONSTANT_ATTR_KEY);
            } else if (isStatic) {
                annotation.setTextAttributes(SmaliHighlighterColors.STATIC_FIELD_ATTR_KEY);
            } else {
                annotation.setTextAttributes(SmaliHighlighterColors.INSTANCE_FIELD_ATTR_KEY);
            }
        }
    }

    @NotNull
    private static Set<String> getAccessModifierNames(@NotNull List<SmaliAccessModifier> accessModifiers) {
        if (accessModifiers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (SmaliAccessModifier accessModifier : accessModifiers) {
            names.add(accessModifier.getText());
        }
        return names;
    }
}

