/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidApkBuilderConfigState;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidApkBuilderConfigStateStorage
extends AbstractStateStorage<String, AndroidApkBuilderConfigState> {
    private AndroidApkBuilderConfigStateStorage(@NotNull File dataStorageRoot, @NotNull String storageName) throws IOException {
        super(AndroidJpsUtil.getStorageFile(dataStorageRoot, storageName), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
    }

    public static class Provider
    extends StorageProvider<AndroidApkBuilderConfigStateStorage> {
        private final String myStorageName;

        public Provider(@NotNull String storageName) {
            this.myStorageName = storageName;
        }

        @NotNull
        public AndroidApkBuilderConfigStateStorage createStorage(File targetDataDir) throws IOException {
            return new AndroidApkBuilderConfigStateStorage(targetDataDir, this.myStorageName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Provider provider = (Provider)((Object)o);
            return this.myStorageName.equals(provider.myStorageName);
        }

        public int hashCode() {
            return this.myStorageName.hashCode();
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidApkBuilderConfigState> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, AndroidApkBuilderConfigState value) throws IOException {
            value.save(out);
        }

        public AndroidApkBuilderConfigState read(@NotNull DataInput in) throws IOException {
            return new AndroidApkBuilderConfigState(in);
        }
    }
}

