/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidAptValidityState;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidAptStateStorage
extends AbstractStateStorage<String, AndroidAptValidityState> {
    public static final StorageProvider<AndroidAptStateStorage> PROVIDER = new StorageProvider<AndroidAptStateStorage>(){

        @NotNull
        public AndroidAptStateStorage createStorage(File targetDataDir) throws IOException {
            return new AndroidAptStateStorage(targetDataDir);
        }
    };
    @NonNls
    private static final String RESOURCE_NAMES_STORAGE = "resource_names";

    private AndroidAptStateStorage(@NotNull File dataStorageRoot) throws IOException {
        super(AndroidJpsUtil.getStorageFile(dataStorageRoot, RESOURCE_NAMES_STORAGE), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidAptValidityState> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, AndroidAptValidityState value) throws IOException {
            value.save(out);
        }

        public AndroidAptValidityState read(@NotNull DataInput in) throws IOException {
            return new AndroidAptValidityState(in);
        }
    }
}

