/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ValueResourcesFileParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidBuildDataCache {
    private static AndroidBuildDataCache ourInstance;
    private final Map<JpsModule, MyAndroidDeps> myModule2AndroidDeps = new HashMap();
    private final Map<String, List<ResourceEntry>> myParsedValueResourceFiles = new HashMap();

    @NotNull
    public static AndroidBuildDataCache getInstance() {
        if (ourInstance == null) {
            ourInstance = new AndroidBuildDataCache();
        }
        return ourInstance;
    }

    public static void clean() {
        ourInstance = null;
    }

    public List<ResourceEntry> getParsedValueResourceFile(@NotNull File file) throws IOException {
        String path = FileUtil.toCanonicalPath((String)file.getPath());
        List<ResourceEntry> entries = this.myParsedValueResourceFiles.get(path);
        if (entries == null) {
            entries = AndroidBuildDataCache.parseValueResourceFile(file);
            this.myParsedValueResourceFiles.put(path, entries);
        }
        return entries;
    }

    @NotNull
    private static List<ResourceEntry> parseValueResourceFile(@NotNull File valueResXmlFile) throws IOException {
        final ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(valueResXmlFile));){
            FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new ValueResourcesFileParser(){

                protected void stop() {
                    throw new FormsParsing.ParserStoppedException();
                }

                protected void process(@NotNull ResourceEntry resourceEntry) {
                    result.add(resourceEntry);
                }
            });
        }
        return result;
    }

    @NotNull
    public List<JpsAndroidModuleExtension> getAllAndroidDependencies(@NotNull JpsModule module, boolean librariesOnly) {
        MyAndroidDeps deps = this.myModule2AndroidDeps.get(module);
        if (deps == null) {
            deps = AndroidBuildDataCache.computeAndroidDependencies(module);
            this.myModule2AndroidDeps.put(module, deps);
        }
        return librariesOnly ? deps.myLibAndroidDeps : deps.myAndroidDeps;
    }

    @NotNull
    private static MyAndroidDeps computeAndroidDependencies(@NotNull JpsModule module) {
        MyAndroidDeps result = new MyAndroidDeps();
        boolean recursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(module);
        AndroidBuildDataCache.collectAndroidDependencies(module, result, (Set<String>)new HashSet(), true, recursively);
        Collections.reverse(result.myAndroidDeps);
        Collections.reverse(result.myLibAndroidDeps);
        return result;
    }

    private static void collectAndroidDependencies(@NotNull JpsModule module, @NotNull MyAndroidDeps result, @NotNull Set<String> visitedSet, boolean fillLibs, boolean recursively) {
        ArrayList dependencies = new ArrayList(JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false));
        for (int i = dependencies.size() - 1; i >= 0; --i) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            JpsDependencyElement item = (JpsDependencyElement)dependencies.get(i);
            if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !visitedSet.add(depModule.getName())) continue;
            if (recursively) {
                boolean newRecursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(depModule);
                AndroidBuildDataCache.collectAndroidDependencies(depModule, result, visitedSet, fillLibs && depExtension.isLibrary(), newRecursively);
            }
            result.myAndroidDeps.add(depExtension);
            if (!fillLibs || !depExtension.isLibrary()) continue;
            result.myLibAndroidDeps.add(depExtension);
        }
    }

    private static class MyAndroidDeps {
        final List<JpsAndroidModuleExtension> myAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();
        final List<JpsAndroidModuleExtension> myLibAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();

        private MyAndroidDeps() {
        }
    }

    public static class ComputationException
    extends Exception {
        public ComputationException(@NotNull String message) {
            super(message);
        }
    }

    private static class ErrorComputedValue<T>
    extends MyComputedValue<T> {
        @NotNull
        private final String myMessage;

        private ErrorComputedValue(@NotNull String message) {
            this.myMessage = message;
        }

        @Override
        @NotNull
        T getValue() throws ComputationException {
            throw new ComputationException(this.myMessage);
        }
    }

    private static class SuccessComputedValue<T>
    extends MyComputedValue<T> {
        @NotNull
        private final T myValue;

        private SuccessComputedValue(@NotNull T value) {
            this.myValue = value;
        }

        @Override
        @NotNull
        T getValue() throws ComputationException {
            return this.myValue;
        }
    }

    private static abstract class MyComputedValue<T> {
        private MyComputedValue() {
        }

        @NotNull
        abstract T getValue() throws ComputationException;
    }
}

