/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidJpsProjectUtil {
    @NonNls
    public static final String ANDROID_STORAGE_DIR = "android";
    @NonNls
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    @NonNls
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    @NonNls
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";

    static JpsAndroidModuleExtension getExtension(@NotNull JpsModule module) {
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull JpsProject project) {
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull ModuleChunk chunk) {
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(@NotNull Collection<JpsModule> modules) {
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsProjectUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    @NotNull
    public static File getGeneratedResourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        return AndroidJpsProjectUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
    }

    @NotNull
    static File getGeneratedResourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
    }

    @NotNull
    public static File getStorageFile(@NotNull File dataStorageRoot, @NotNull String storageName) {
        return new File(AndroidJpsProjectUtil.getStorageDir(dataStorageRoot, storageName), storageName);
    }

    @NotNull
    public static File getStorageDir(@NotNull File dataStorageRoot, @NotNull String storageName) {
        return new File(new File(dataStorageRoot, ANDROID_STORAGE_DIR), storageName);
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
    }

    @NotNull
    public static File getCopiedSourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
    }
}

