/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class AndroidBuildTargetType<T extends AndroidBuildTarget>
extends BuildTargetType<T> {
    private final String myPresentableName;

    AndroidBuildTargetType(@NotNull String typeId, @NotNull String presentableName) {
        super(typeId);
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
            return Collections.emptyList();
        }
        ArrayList<T> targets = new ArrayList<T>();
        for (JpsModule module : model.getProject().getModules()) {
            T target;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || (target = this.createBuildTarget(extension)) == null) continue;
            targets.add(target);
        }
        return targets;
    }

    @Nullable
    public abstract T createBuildTarget(@NotNull JpsAndroidModuleExtension var1);

    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        final HashMap<String, AndroidBuildTarget> targetMap = new HashMap<String, AndroidBuildTarget>();
        for (AndroidBuildTarget target : this.computeAllTargets(model)) {
            targetMap.put(target.getId(), target);
        }
        return new BuildTargetLoader<T>(){

            @Nullable
            public T createTarget(@NotNull String targetId) {
                return (Object)((AndroidBuildTarget)((Object)targetMap.get(targetId)));
            }
        };
    }
}

