/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.compiler.tools.AndroidApkBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidDexBuildTarget;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPackagingBuildTarget
extends AndroidBuildTarget {
    public AndroidPackagingBuildTarget(@NotNull JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    @NotNull
    public static String[] collectNativeLibsFolders(@NotNull JpsAndroidModuleExtension extension, boolean checkExistence) {
        ArrayList<String> result = new ArrayList<String>();
        File libsDir = extension.getNativeLibsDir();
        if (libsDir != null && (!checkExistence || libsDir.exists())) {
            result.add(libsDir.getPath());
        }
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
            File depLibsDir = depExtension.getNativeLibsDir();
            if (depLibsDir == null || checkExistence && !depLibsDir.exists()) continue;
            result.add(depLibsDir.getPath());
        }
        return ArrayUtil.toStringArray(result);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File resPackage = AndroidResourcePackagingBuildTarget.getOutputFile(dataPaths, this.myModule);
        File classesDexFile = AndroidDexBuildTarget.getOutputFile(dataPaths, this.myModule);
        ArrayList<BuildRootDescriptor> roots = new ArrayList<BuildRootDescriptor>();
        roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, resPackage));
        roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, classesDexFile));
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, true, false)) {
                roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(jarOrLibDir), false));
            }
        }
        for (File resourceRoot : AndroidJpsUtil.getJavaOutputRootsForModuleAndDependencies(this.myModule)) {
            roots.add((BuildRootDescriptor)new MyResourceRootDescriptor(this, resourceRoot));
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        for (String nativeLibDir : AndroidPackagingBuildTarget.collectNativeLibsFolders(extension, false)) {
            roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(nativeLibDir)));
        }
        return roots;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)this.myModule, (boolean)false);
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (moduleOutputDir == null || extension == null) {
            return Collections.emptyList();
        }
        String outputPath = AndroidJpsUtil.getApkPath(extension, moduleOutputDir);
        if (outputPath == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new File(outputPath));
    }

    @Override
    protected void fillDependencies(List<BuildTarget<?>> result) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (extension != null && !extension.isLibrary()) {
            result.add(new AndroidDexBuildTarget(this.myModule));
            result.add(new AndroidResourcePackagingBuildTarget(this.myModule));
        }
    }

    private static class MyResourceRootDescriptor
    extends BuildRootDescriptorImpl {
        private MyResourceRootDescriptor(BuildTarget target, File root) {
            super(target, root);
        }

        @NotNull
        public FileFilter createFileFilter() {
            return new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return AndroidApkBuilder.checkFileForPackaging((File)file);
                }
            };
        }
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidPackagingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-packaging", "Packaging");
        }

        @Override
        public AndroidPackagingBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            return new AndroidPackagingBuildTarget(extension.getModule());
        }
    }
}

