/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGradleLinkedProjectAction
extends AnAction {
    public void update(AnActionEvent e) {
        Pair<Project, String> pair = AbstractGradleLinkedProjectAction.deriveProjects(e.getDataContext());
        boolean visible = pair != null;
        e.getPresentation().setVisible(visible);
        if (!visible) {
            return;
        }
        this.doUpdate(e, (Project)pair.first, (String)pair.second);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Pair<Project, String> pair = AbstractGradleLinkedProjectAction.deriveProjects(e.getDataContext());
        if (pair == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        this.doActionPerformed(e, project, (String)pair.second);
    }

    @Nullable
    private static Pair<Project, String> deriveProjects(@Nullable DataContext context) {
        if (context == null) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        return null;
    }

    protected abstract void doUpdate(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull String var3);

    protected abstract void doActionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull String var3);
}

