/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class MultipleRepositoryUrlsFix
extends GroovyFix {
    private final GrClosableBlock myClosure;
    private final String myRepoType;

    public MultipleRepositoryUrlsFix(@NotNull GrClosableBlock closure, @NotNull String repoType) {
        this.myClosure = closure;
        this.myRepoType = repoType;
    }

    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(this.myClosure);
        if (statements.size() <= 1) {
            return;
        }
        statements.remove(0);
        ArrayList<GrCallExpression> elements = new ArrayList<GrCallExpression>(statements);
        for (GrCallExpression statement : statements) {
            PsiElement newLineCandidate = statement.getNextSibling();
            if (!PsiUtil.isNewLine((PsiElement)newLineCandidate)) continue;
            elements.add((GrCallExpression)newLineCandidate);
        }
        this.myClosure.removeElements(elements.toArray(new PsiElement[elements.size()]));
        GrClosableBlock closableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)this.myClosure, GrClosableBlock.class);
        if (closableBlock == null) {
            return;
        }
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance((Project)project);
        for (GrCallExpression statement : statements) {
            closableBlock.addStatementBefore(elementFactory.createStatementFromText((CharSequence)(this.myRepoType + '{' + statement.getText() + '}')), null);
        }
    }

    @NotNull
    public String getFamilyName() {
        return GradleInspectionBundle.message("multiple.repository.urls.fix.name", new Object[0]);
    }
}

