/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public class GradleClassFinder
extends NonClasspathClassFinder {
    @NotNull
    private final GradleBuildClasspathManager myBuildClasspathManager;
    private final Map<String, PackageDirectoryCache> myCaches = new ConcurrentFactoryMap<String, PackageDirectoryCache>(){

        @Nullable
        protected PackageDirectoryCache create(String path) {
            return GradleClassFinder.createCache((List)GradleClassFinder.this.myBuildClasspathManager.getModuleClasspathEntries(path));
        }
    };

    public GradleClassFinder(@NotNull Project project, @NotNull GradleBuildClasspathManager buildClasspathManager) {
        super(project, new String[]{"java", "groovy"});
        this.myBuildClasspathManager = buildClasspathManager;
    }

    protected List<VirtualFile> calcClassRoots() {
        return this.myBuildClasspathManager.getAllClasspathEntries();
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        if (scope instanceof ExternalModuleBuildGlobalSearchScope) {
            return this.myCaches.get(((ExternalModuleBuildGlobalSearchScope)scope).getExternalModulePath());
        }
        return super.getCache(scope);
    }

    public void clearCache() {
        super.clearCache();
        this.myCaches.clear();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass aClass = super.findClass(qualifiedName, scope);
        if (aClass == null || scope instanceof ExternalModuleBuildGlobalSearchScope || scope instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInContent(file) && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInLibraryClasses(file) && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInLibrarySource(file) ? aClass : null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (scope instanceof ExternalModuleBuildGlobalSearchScope) {
            return super.getSubPackages(psiPackage, scope);
        }
        return PsiPackage.EMPTY_ARRAY;
    }
}

