/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleScriptType;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GradlePositionManager
extends ScriptPositionManagerHelper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.gradle.config.GradlePositionManager");
    private static final Pattern GRADLE_CLASS_PATTERN = Pattern.compile(".*_gradle_.*");
    private static final String SCRIPT_CLOSURE_PREFIX = "build_";
    private static final Key<CachedValue<ClassLoader>> GRADLE_CLASS_LOADER = Key.create((String)"GRADLE_CLASS_LOADER");
    private static final Key<CachedValue<FactoryMap<File, String>>> GRADLE_CLASS_NAME = Key.create((String)"GRADLE_CLASS_NAME");
    private final GradleInstallationManager myLibraryManager;

    public GradlePositionManager(@NotNull GradleInstallationManager manager) {
        this.myLibraryManager = manager;
    }

    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        return runtimeName.startsWith(SCRIPT_CLOSURE_PREFIX) || GRADLE_CLASS_PATTERN.matcher(runtimeName).matches();
    }

    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)scriptFile, (GroovyScriptType)GradleScriptType.INSTANCE);
    }

    @NotNull
    public String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        VirtualFile virtualFile = groovyFile.getVirtualFile();
        if (virtualFile == null) {
            return "";
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)groovyFile);
        if (module == null) {
            return "";
        }
        File scriptFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        String className = (String)((FactoryMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, GRADLE_CLASS_NAME, (CachedValueProvider)new ScriptSourceMapCalculator(module), false)).get((Object)scriptFile);
        return className == null ? "" : className;
    }

    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        String sourceFilePath = GradlePositionManager.getScriptForClassName(refType);
        if (sourceFilePath == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)sourceFilePath));
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(virtualFile);
    }

    @Nullable
    private static String getScriptForClassName(@NotNull ReferenceType refType) {
        try {
            List<String> data = refType.sourcePaths(null);
            if (!data.isEmpty()) {
                return data.get(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private ClassLoader getGradleClassLoader(@NotNull Module module) {
        Project project = module.getProject();
        return (ClassLoader)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, GRADLE_CLASS_LOADER, () -> CachedValueProvider.Result.create((Object)this.createGradleClassLoader(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}), false);
    }

    @Nullable
    private ClassLoader createGradleClassLoader(@NotNull Module module) {
        String rootProjectPath = module.getOptionValue("external.root.project.path");
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            return null;
        }
        VirtualFile sdkHome = this.myLibraryManager.getGradleHome(module, module.getProject(), rootProjectPath);
        if (sdkHome == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        VirtualFile libDir = sdkHome.findChild("lib");
        assert (libDir != null);
        for (VirtualFile child : libDir.getChildren()) {
            if (!"jar".equals(child.getExtension())) continue;
            urls.add(VfsUtilCore.convertToURL((String)child.getUrl()));
        }
        return UrlClassLoader.build().urls(urls).get();
    }

    private class ScriptSourceMapCalculator
    implements CachedValueProvider<FactoryMap<File, String>> {
        private final Module myModule;

        public ScriptSourceMapCalculator(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<FactoryMap<File, String>> compute() {
            ConcurrentFactoryMap<File, String> result = new ConcurrentFactoryMap<File, String>(){

                protected String create(File scriptFile) {
                    return ScriptSourceMapCalculator.this.calcClassName(scriptFile);
                }
            };
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }

        @Nullable
        private String calcClassName(File scriptFile) {
            ClassLoader loader = GradlePositionManager.this.getGradleClassLoader(this.myModule);
            if (loader != null) {
                Class<?> fileScriptSource;
                try {
                    fileScriptSource = Class.forName("org.gradle.groovy.scripts.UriScriptSource", true, loader);
                }
                catch (ClassNotFoundException e) {
                    try {
                        fileScriptSource = Class.forName("org.gradle.groovy.scripts.FileScriptSource", true, loader);
                    }
                    catch (ClassNotFoundException e1) {
                        return null;
                    }
                }
                try {
                    Object source = fileScriptSource.getConstructor(String.class, File.class).newInstance("script", scriptFile);
                    return (String)fileScriptSource.getMethod("getClassName", new Class[0]).invoke(source, new Object[0]);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            return null;
        }
    }
}

