/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final Logger LOG = Logger.getInstance(GradleOrderEnumeratorHandler.class);
    private final boolean myResolveModulePerSourceSet;
    private final boolean myShouldProcessDependenciesRecursively;

    public GradleOrderEnumeratorHandler(@NotNull Module module) {
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath != null) {
            GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(module.getProject()).getLinkedProjectSettings(rootProjectPath);
            this.myResolveModulePerSourceSet = settings != null && settings.isResolveModulePerSourceSet();
            String gradleVersion = GradleLocalSettings.getInstance(module.getProject()).getGradleVersion(rootProjectPath);
            this.myShouldProcessDependenciesRecursively = gradleVersion != null && GradleVersion.version((String)gradleVersion).compareTo(GradleVersion.version((String)"2.5")) < 0;
        } else {
            this.myShouldProcessDependenciesRecursively = false;
            this.myResolveModulePerSourceSet = false;
        }
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return this.myResolveModulePerSourceSet;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return this.myShouldProcessDependenciesRecursively;
    }

    public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests) {
        if (!type.equals((Object)OrderRootType.CLASSES)) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        String gradleProjectPath = rootModel.getModule().getOptionValue("external.root.project.path");
        if (gradleProjectPath == null) {
            LOG.error("Root project path of the Gradle project not found for " + rootModel.getModule());
            return false;
        }
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance(rootModel.getModule().getProject());
        assert (externalProjectDataCache != null);
        ExternalProject externalRootProject = externalProjectDataCache.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
        if (externalRootProject == null) {
            LOG.debug("Root external project was not yep imported for the project path: " + gradleProjectPath);
            return false;
        }
        Map<String, ExternalSourceSet> externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
        if (externalSourceSets.isEmpty()) {
            return false;
        }
        for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
            if (includeTests) {
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), result);
            }
            if (!includeProduction) continue;
            GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), result);
        }
        return true;
    }

    private static void addOutputModuleRoots(@Nullable ExternalSourceDirectorySet directorySet, @NotNull Collection<String> result) {
        if (directorySet == null) {
            return;
        }
        if (directorySet.isCompilerOutputPathInherited()) {
            return;
        }
        String path = directorySet.getOutputDir().getAbsolutePath();
        result.add(VfsUtilCore.pathToUrl((String)path));
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited()) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            return new GradleOrderEnumeratorHandler(module);
        }
    }
}

