/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.task.ExecuteRunConfigurationTask;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleApplicationEnvironmentProvider
implements GradleExecutionEnvironmentProvider {
    @Override
    public boolean isApplicable(ExecuteRunConfigurationTask task) {
        return task.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Override
    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask executeRunConfigurationTask, @Nullable Executor executor) {
        if (!this.isApplicable(executeRunConfigurationTask)) {
            return null;
        }
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)executeRunConfigurationTask.getRunProfile();
        PsiClass mainClass = applicationConfiguration.getMainClass();
        if (mainClass == null) {
            return null;
        }
        VirtualFile virtualFile = mainClass.getContainingFile().getVirtualFile();
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile);
        if (module == null) {
            return null;
        }
        JavaParameters params = new JavaParameters();
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)applicationConfiguration);
        params.getVMParametersList().addParametersString(applicationConfiguration.getVMParameters());
        String javaExePath = null;
        try {
            Sdk jdk = JavaParametersUtil.createProjectJdk((Project)project, (String)applicationConfiguration.getAlternativeJrePath());
            if (jdk == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            SdkTypeId type = jdk.getSdkType();
            if (!(type instanceof JavaSdkType)) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            javaExePath = ((JavaSdkType)type).getVMExecutablePath(jdk);
            if (javaExePath == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.cannot.find.vm.executable", (Object[])new Object[0]));
            }
            javaExePath = FileUtil.toSystemIndependentName((String)javaExePath);
        }
        catch (CantRunException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)"Cannot use specified JRE", (Project)project);
        }
        StringBuilder parametersString = new StringBuilder();
        for (Object parameter : params.getProgramParametersList().getParameters()) {
            parametersString.append("args '").append((String)parameter).append("'\n");
        }
        StringBuilder vmParametersString = new StringBuilder();
        for (String parameter : params.getVMParametersList().getParameters()) {
            vmParametersString.append("jvmArgs '").append(parameter).append("'\n");
        }
        ExternalSystemTaskExecutionSettings taskSettings = new ExternalSystemTaskExecutionSettings();
        taskSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        taskSettings.setExternalProjectPath(ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        String runAppTaskName = "run " + mainClass.getName();
        taskSettings.setTaskNames(Collections.singletonList(runAppTaskName));
        String executorId = executor == null ? DefaultRunExecutor.EXECUTOR_ID : executor.getId();
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)taskSettings, (String)executorId);
        if (environment != null) {
            String sourceSetName;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
            assert (runnerAndConfigurationSettings != null);
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            String gradlePath = GradleProjectResolverUtil.getGradlePath(module);
            if (gradlePath == null) {
                return null;
            }
            if ("sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
                sourceSetName = GradleProjectResolverUtil.getSourceSetName(module);
            } else {
                String string = sourceSetName = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile) ? "test" : "main";
            }
            if (sourceSetName == null) {
                return null;
            }
            String initScript = "projectsEvaluated {\n  rootProject.allprojects {\n    if(project.path == '" + gradlePath + "' && project.sourceSets) {\n      project.tasks.create(name: '" + runAppTaskName + "', overwrite: true, type: JavaExec) {\n" + (javaExePath != null ? "        executable = '" + javaExePath + "'\n" : "") + "        classpath = project.sourceSets.'" + sourceSetName + "'.runtimeClasspath\n        main = '" + mainClass.getQualifiedName() + "'\n" + parametersString.toString() + vmParametersString.toString() + "      }\n    }\n  }\n}\n";
            runConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
            return environment;
        }
        return null;
    }
}

