/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class TestClassGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    public TestClassGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null) {
            return false;
        }
        sourceElement.set((Object)testClass);
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = TestClassGradleConfigurationProducer.getTasksToRun(module);
        if (tasksToRun.isEmpty()) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(tasksToRun);
        configuration.getSettings().setScriptParameters(String.format("--tests %s", testClass.getQualifiedName()));
        configuration.setName(testClass.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(Location contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Nullable
    protected PsiClass getPsiClassForLocation(Location contextLocation) {
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return null;
        }
        return JUnitUtil.getTestClass((Location)location);
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        if (this.getPsiMethodForLocation(contextLocation) != null) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null || testClass.getQualifiedName() == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = this.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TestClassGradleConfigurationProducer.getTasksToRun(context.getModule()))) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        int i = scriptParameters.indexOf("--tests ");
        if (i == -1) {
            return false;
        }
        String str = scriptParameters.substring(i + "--tests ".length()).trim() + ' ';
        return str.startsWith(testClass.getQualifiedName() + ' ') && !str.contains("--tests");
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, @NotNull Runnable performRunnable) {
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, (PsiClass[])ArrayUtil.toObjectArray(classes, PsiClass.class))) {
                    return;
                }
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, new PsiClass[]{aClass})) {
                    return;
                }
                super.runForClass(aClass, psiMethod, context, performRunnable);
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, null, (PsiClass)fromContext.getSourceElement())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    private static boolean applyTestConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, PsiClass ... containingClasses) {
        Module module = context.getModule();
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = TestClassGradleConfigurationProducer.getTasksToRun(module);
        if (tasksToRun.isEmpty()) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(tasksToRun);
        StringBuilder buf = new StringBuilder();
        for (PsiClass aClass2 : containingClasses) {
            buf.append(String.format("--tests %s ", aClass2.getQualifiedName()));
        }
        configuration.getSettings().setScriptParameters(buf.toString());
        configuration.setName(StringUtil.join((Object[])containingClasses, aClass -> aClass.getName(), (String)"|"));
        return true;
    }
}

