/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterSuiteEvent
extends AbstractTestEvent {
    public AfterSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        this.addToInvokeLater(() -> {
            SMTestProxy testProxy = this.findTestProxy(testId);
            if (testProxy == null) {
                return;
            }
            switch (result) {
                case SUCCESS: {
                    testProxy.setFinished();
                    break;
                }
                case FAILURE: {
                    testProxy.setTestFailed("", null, false);
                    break;
                }
                case SKIPPED: {
                    testProxy.setTestIgnored(null, null);
                    break;
                }
            }
            this.getResultsViewer().onSuiteFinished(testProxy);
        });
    }
}

