/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.util.CompositeRunnable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterTestEvent
extends AbstractTestEvent {
    public AfterTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        String startTime = eventXml.getEventTestResultStartTime();
        String endTime = eventXml.getEventTestResultEndTime();
        String exceptionMsg = this.decode(eventXml.getEventTestResultErrorMsg());
        String stackTrace = this.decode(eventXml.getEventTestResultStackTrace());
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        try {
            testProxy.setDuration(Long.valueOf(endTime) - Long.valueOf(startTime));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CompositeRunnable runInEdt = new CompositeRunnable();
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        switch (result) {
            case SUCCESS: {
                runInEdt.add(() -> ((SMTestProxy)testProxy).setFinished());
                break;
            }
            case FAILURE: {
                String failureType = eventXml.getEventTestResultFailureType();
                if ("comparison".equals(failureType)) {
                    String actualText = this.decode(eventXml.getEventTestResultActual());
                    String expectedText = this.decode(eventXml.getEventTestResultExpected());
                    Condition emptyString = StringUtil::isEmpty;
                    String filePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultFilePath()), (Condition)emptyString);
                    String actualFilePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultActualFilePath()), (Condition)emptyString);
                    testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, actualText, expectedText, filePath, actualFilePath);
                } else {
                    Couple<String> comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n");
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: is \"(.*)\"\n\\s*but: was \"(.*)\"");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: (.*)\n\\s*got: (.*)");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\\s*expected same:<(.*)> was not:<(.*)>");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, ".*\\s*expected:<(.*)> but was:<(.*)>");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: \"(.*)\"\n\\s*but: was \"(.*)\"");
                    }
                    Couple<String> finalComparisonPair = comparisonPair;
                    runInEdt.add(() -> {
                        if (finalComparisonPair != null) {
                            testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, (String)finalComparisonPair.second, (String)finalComparisonPair.first);
                        } else {
                            testProxy.setTestFailed(exceptionMsg, stackTrace, "error".equals(failureType));
                        }
                    });
                }
                runInEdt.add(() -> this.getResultsViewer().onTestFailed(testProxy));
                break;
            }
            case SKIPPED: {
                runInEdt.add(() -> {
                    testProxy.setTestIgnored(null, null);
                    this.getResultsViewer().onTestIgnored(testProxy);
                });
                break;
            }
        }
        runInEdt.add(() -> this.getResultsViewer().onTestFinished(testProxy));
        this.addToInvokeLater((Runnable)runInEdt);
    }

    private static Couple<String> parseComparisonMessage(String message, String regex) {
        Matcher matcher = Pattern.compile(regex, 34).matcher(message);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1).replaceAll("\\\\n", "\n"), (Object)matcher.group(2).replaceAll("\\\\n", "\n"));
        }
        return null;
    }
}

