/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildScriptClasspathData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Key<BuildScriptClasspathData> KEY = Key.create(BuildScriptClasspathData.class, (int)(ProjectKeys.LIBRARY_DEPENDENCY.getProcessingWeight() + 1));
    @Nullable
    private File gradleHomeDir;
    @NotNull
    private final List<ClasspathEntry> myClasspathEntries;

    public BuildScriptClasspathData(@NotNull ProjectSystemId owner, @NotNull List<ClasspathEntry> classpathEntries) {
        super(owner);
        this.myClasspathEntries = classpathEntries;
    }

    @Nullable
    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void setGradleHomeDir(@Nullable File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    @NotNull
    public List<ClasspathEntry> getClasspathEntries() {
        return this.myClasspathEntries;
    }

    public static class ClasspathEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NotNull
        private final Set<String> myClassesFile;
        @NotNull
        private final Set<String> mySourcesFile;
        @NotNull
        private final Set<String> myJavadocFile;

        public ClasspathEntry(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            this.myClassesFile = classesFile;
            this.mySourcesFile = sourcesFile;
            this.myJavadocFile = javadocFile;
        }

        @NotNull
        public Set<String> getClassesFile() {
            return this.myClassesFile;
        }

        @NotNull
        public Set<String> getSourcesFile() {
            return this.mySourcesFile;
        }

        @NotNull
        public Set<String> getJavadocFile() {
            return this.myJavadocFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry entry = (ClasspathEntry)o;
            if (!this.myClassesFile.equals(entry.myClassesFile)) {
                return false;
            }
            if (!this.myJavadocFile.equals(entry.myJavadocFile)) {
                return false;
            }
            return this.mySourcesFile.equals(entry.mySourcesFile);
        }

        public int hashCode() {
            int result = this.myClassesFile.hashCode();
            result = 31 * result + this.mySourcesFile.hashCode();
            result = 31 * result + this.myJavadocFile.hashCode();
            return result;
        }
    }
}

