/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collection;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class DefaultProjectResolverContext
extends UserDataHolderBase
implements ProjectResolverContext {
    @NotNull
    private final ExternalSystemTaskId myExternalSystemTaskId;
    @NotNull
    private final String myProjectPath;
    @Nullable
    private final GradleExecutionSettings mySettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    private ProjectConnection myConnection;
    @Nullable
    private CancellationTokenSource myCancellationTokenSource;
    private final boolean myIsPreviewMode;
    @NotNull
    private ProjectImportAction.AllModels myModels;

    public DefaultProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, boolean isPreviewMode) {
        this(externalSystemTaskId, projectPath, settings, null, listener, isPreviewMode);
    }

    public DefaultProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener, boolean isPreviewMode) {
        this.myExternalSystemTaskId = externalSystemTaskId;
        this.myProjectPath = projectPath;
        this.mySettings = settings;
        this.myConnection = connection;
        this.myListener = listener;
        this.myIsPreviewMode = isPreviewMode;
    }

    @Override
    @NotNull
    public ExternalSystemTaskId getExternalSystemTaskId() {
        return this.myExternalSystemTaskId;
    }

    @Override
    @Nullable
    public String getIdeProjectPath() {
        return this.mySettings != null ? this.mySettings.getIdeProjectPath() : null;
    }

    @Override
    @NotNull
    public String getProjectPath() {
        return this.myProjectPath;
    }

    @Override
    @Nullable
    public GradleExecutionSettings getSettings() {
        return this.mySettings;
    }

    @Override
    @NotNull
    public ProjectConnection getConnection() {
        return this.myConnection;
    }

    public void setConnection(@NotNull ProjectConnection connection) {
        this.myConnection = connection;
    }

    @Override
    @Nullable
    public CancellationTokenSource getCancellationTokenSource() {
        return this.myCancellationTokenSource;
    }

    public void setCancellationTokenSource(@Nullable CancellationTokenSource cancellationTokenSource) {
        this.myCancellationTokenSource = cancellationTokenSource;
    }

    @Override
    @NotNull
    public ExternalSystemTaskNotificationListener getListener() {
        return this.myListener;
    }

    @Override
    public boolean isPreviewMode() {
        return this.myIsPreviewMode;
    }

    @Override
    public boolean isResolveModulePerSourceSet() {
        return this.mySettings == null || this.mySettings.isResolveModulePerSourceSet();
    }

    @Override
    @NotNull
    public ProjectImportAction.AllModels getModels() {
        return this.myModels;
    }

    @Override
    public void setModels(@NotNull ProjectImportAction.AllModels models) {
        this.myModels = models;
    }

    @Override
    @Nullable
    public <T> T getExtraProject(Class<T> modelClazz) {
        return (T)this.myModels.getExtraProject((IdeaModule)null, modelClazz);
    }

    @Override
    @Nullable
    public <T> T getExtraProject(@Nullable IdeaModule module, Class<T> modelClazz) {
        return (T)this.myModels.getExtraProject((Object)(module != null ? module.getGradleProject() : null), modelClazz);
    }

    @Override
    @NotNull
    public Collection<String> findModulesWithModel(@NotNull Class modelClazz) {
        return this.myModels.findModulesWithModel(modelClazz);
    }

    @Override
    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        return this.myModels.hasModulesWithModel(modelClazz);
    }

    @Override
    public void checkCancelled() {
        if (this.myCancellationTokenSource != null && this.myCancellationTokenSource.token().isCancellationRequested()) {
            throw new ProcessCanceledException();
        }
    }
}

