/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.DistributionInstaller;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactoryExt
extends DistributionFactory {
    public Distribution getWrappedDistribution(File propertiesFile) {
        WrapperExecutor wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration());
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration) {
            this.wrapperConfiguration = wrapperConfiguration;
        }

        public String getDisplayName() {
            return "Gradle distribution '" + this.wrapperConfiguration.getDistribution() + "'";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                final DistributionInstaller installer = new DistributionInstaller(progressLoggerFactory, progressListener);
                try {
                    cancellationToken.addCallback(new Runnable(){

                        @Override
                        public void run() {
                            installer.cancel();
                        }
                    });
                    File realUserHomeDir = userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
                    installDir = installer.install(realUserHomeDir, this.wrapperConfiguration);
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, userHomeDir, cancellationToken);
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            Object[] files = libDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return FileUtils.hasExtension((File)file, (String)".jar");
                }
            });
            Arrays.sort(files);
            return new DefaultClassPath((File[])files);
        }
    }
}

